#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.commons.common_utils import CommonUtils
from xld.kubernetes.core_api_client import KubernetesCoreClient
from xld.kubernetes.service.service_helper import ServiceHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory


class ServiceService(object):

    def __init__(self):
        self.__service_helper = ServiceHelper()
        self.__kind = CommonUtils.get_kind(self)

    def create_service(self, deployed):
        with self.__create_client(deployed.container.container) as client:
            service_request = self.__service_helper.read_service(deployed_service=deployed)
            container_helper = self.__create_container_helper(deployed.container)
            print("Creating Service '{0}' in {1} '{2}' ".format(self.__service_helper.get_service_name(deployed),
                                                                container_helper.get_container_label(),
                                                                container_helper.get_container_name(
                                                                    deployed.container)))
            CommonUtils.print_request_dump(deployed.container.container, service_request, self.__kind,
                                           client.get_api_version())
            service_response = client.create_service(service_request, container_helper.get_container_name(
                deployed.container))
        CommonUtils.print_response_dump(deployed.container.container, service_response)
        return service_response

    def create_service_using_data(self, deployed, data):
        with self.__create_client(deployed.container.container) as client:
            container_helper = self.__create_container_helper(deployed.container)
            print "Creating Service '{0}' in '{1}' ".format(data['metadata']['name'],
                                                            container_helper.get_container_name(
                                                                deployed.container))
            CommonUtils.print_request_dump(deployed.container.container, data, self.__kind,
                                           client.get_api_version())
            service_response = client.create_service(data, container_helper.get_container_name(
                deployed.container))
        CommonUtils.print_response_dump(deployed.container.container, service_response)
        node_port = None
        service_port = None
        if bool(service_response.spec.ports):
            for port in service_response.spec.ports:
                node_port = port.node_port
                service_port = port.port
        print "Service '{0}' created with nodePort : '{1}', port:'{2}' ".format(data['metadata']['name'],node_port,service_port)
        return service_response

    def update_service(self, deployed, previousDeployed):
        with self.__create_client(deployed.container.container) as client:
            service_request = self.__service_helper.read_service(deployed_service=deployed)
            container_helper = self.__create_container_helper(deployed.container)
            print("Updating Service '{0}' in {1} '{2}' ".format(
                self.__service_helper.get_service_name(previousDeployed),
                container_helper.get_container_label(),
                container_helper.get_container_name(deployed.container)))
            CommonUtils.print_request_dump(deployed.container.container, service_request, self.__kind,
                                           client.get_api_version())
            self.__service_helper.read_output_properties(service_request, previousDeployed)
            service_response = client.replace_service(self.__service_helper.get_service_name(previousDeployed),
                                                      service_request, container_helper.get_container_name(
                    deployed.container))
        CommonUtils.print_response_dump(deployed.container.container, service_response)
        return service_response

    def destroy_service(self, previousDeployed):
        with self.__create_client(previousDeployed.container.container) as client:
            container_helper = self.__create_container_helper(previousDeployed.container)
            print "Destroying Service '{0}' from {1} '{2}' ".format(
                self.__service_helper.get_service_name(previousDeployed),
                container_helper.get_container_label(),
                container_helper.get_container_name(previousDeployed.container))
            client.remove_service(self.__service_helper.get_service_name(previousDeployed),
                                  container_helper.get_container_name(
                                      previousDeployed.container))

    def destroy_service_using_data(self, previousDeployed, data):
        with self.__create_client(previousDeployed.container.container) as client:
            container_helper = self.__create_container_helper(previousDeployed.container)
            print("Destroying Service '{0}' from '{1}' ".format(data['metadata']['name'],
                                                                container_helper.get_container_name(
                                                                    previousDeployed.container)))
            client.remove_service(data['metadata']['name'],
                                  container_helper.get_container_name(
                                      previousDeployed.container))

    def should_wait_for_service_creation(self, deployed):
        with self.__create_client(deployed.container.container) as client:
            if not client.is_service_existing(self.__service_helper.get_service_name(deployed),
                                              self.__create_container_helper(deployed.container)
                                                  .get_container_name(deployed.container)):
                print("Waiting for Service {0} to be created.".format(
                    self.__service_helper.get_service_name(deployed)))
                return True
            return False

    def should_wait_for_service_deletion(self, previousDeployed):
        with self.__create_client(previousDeployed.container.container) as client:
            if client.is_service_existing(self.__service_helper.get_service_name(previousDeployed),
                                          self.__create_container_helper(previousDeployed.container).get_container_name(
                                              previousDeployed.container)):
                print("Waiting for Service {0} to be destroyed.".format(
                    self.__service_helper.get_service_name(previousDeployed)))
                return True
            return False

    def if_service_exists(self, deployed, service_name):
        with self.__create_client(deployed.container.container) as client:
            if client.is_service_existing(service_name,
                                          self.__create_container_helper(deployed.container)
                                              .get_container_name(deployed.container)):
                return True
            else:
                return False

    @staticmethod
    def __create_client(container):
        return KubernetesCoreClient(container)

    @staticmethod
    def __create_container_helper(container):
        return ContainerHelperFactory(container).create()
