#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from kubernetes import client
from kubernetes.client.api_client import ApiClient
import cPickle as pk

from xld.kubernetes.commons.common_utils import CommonUtils


class PersistentVolumeHelper(object):
    def read_persistent_volume(self, deployed):
        persistent_volume = client.V1PersistentVolume()
        persistent_volume.metadata = self.__read_metadata(deployed)

        spec = client.V1PersistentVolumeSpec()
        spec.access_modes = deployed.accessModes
        spec.persistent_volume_reclaim_policy = deployed.persistentVolumeReclaimPolicy
        persistent_volume.spec = spec

        persistent_volume_dict = ApiClient().sanitize_for_serialization(persistent_volume)
        PersistentVolumeHelper.__apply_dict_properties(deployed, persistent_volume_dict)
        return persistent_volume_dict

    def __read_metadata(self, deployed):
        metadata = client.V1ObjectMeta(name=self.get_name(deployed))
        if deployed.labels:
            metadata.labels = deployed.labels
        metadata.annotations = PersistentVolumeHelper.__read_annotations(deployed)
        return metadata

    @staticmethod
    def __read_annotations(deployed):
        annotations = {}
        if deployed.storageClassName:
            annotations['volume.beta.kubernetes.io/storage-class'] = deployed.storageClassName
        if deployed.mountOptions:
            separator = " "
            mount_options = separator.join(deployed.mountOptions)
            annotations['volume.beta.kubernetes.io/mount-options'] = mount_options
        return annotations

    @staticmethod
    def __apply_dict_properties(deployed, persistent_volume_dict):
        persistent_volume_dict['spec']['capacity'] = PersistentVolumeHelper.__get_capacity_dict(deployed)
        persistent_volume_dict['spec'][deployed.volumeType] = CommonUtils.get_properties_dict(
            deployed.volumeProperties)

    @staticmethod
    def get_name(deployed):
        return deployed.volumeName if deployed.volumeName else deployed.name

    @staticmethod
    def __get_capacity_dict(deployed):
        capacity_prop = {}
        capacity_prop['storage'] = deployed.storage
        return capacity_prop
