#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
import sys

from xld.kubernetes import *
from xld.kubernetes.eks.eks_helper import EKSHelper
from xld.kubernetes.gke.gke_helper import GKEHelper

print "------------------"
print "Testing connection to Kubernetes Cluster {0}".format(thisCi.name)
print "------------------"
try:
    # AWS EKS - Get session token
    if thisCi.isEKS:
        print "Generating AWS k8s token.."
        if thisCi.sessionToken is None:
            helper = EKSHelper(thisCi.accessKey, thisCi.accessSecret, thisCi.isAssumeRole, thisCi.accountId, thisCi.roleName, thisCi.durationSeconds)
        else:
            helper = EKSHelper(thisCi.accessKey, thisCi.accessSecret, thisCi.isAssumeRole, thisCi.accountId, thisCi.roleName, thisCi.durationSeconds, thisCi.sessionToken, thisCi.roleArn)
        token = helper.get_k8s_token(thisCi.clusterName, thisCi.useGlobal, region_name=thisCi.regionName)
        if token:
            thisCi.token = token
        else:
            raise RuntimeError("Cannot generate k8s token from AWS")

    # Google GKE - Get session token
    if thisCi.isGKE:
        gke_helper = GKEHelper()
        gketoken = gke_helper.get_gke_token(thisCi.clientEmail, thisCi.privateKey, thisCi.projectId)
        if gketoken:
            thisCi.token = gketoken
        else:
            raise RuntimeError("Cannot generate k8s token from GKE")

    with KubernetesBaseClient(thisCi) as client:
        versions = client.get_code_version()
        if versions is None:
            raise RuntimeError("Connection Unsuccessful !")
        print "Connection Successful !"
except Exception as e:
    message = ""
    if not ((thisCi.tlsCert and thisCi.tlsPrivateKey) or (thisCi.token) or
                (thisCi.username and thisCi.password)):
        message = "Authentication information is missing. "

    print "Connection Failed: {0}{1}".format(message, str(e))
    sys.exit(1)
