#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.deployment.deployment_helper import DeploymentHelper


class DeploymentStepsGenerator(object):
    def __init__(self, context, steps):
        self.__context = context
        self.__steps = steps
        self.__deployment_helper = DeploymentHelper()

    def replace(self, delta, deployed, previousDeployed):
        container_helper = ContainerHelperFactory(deployed.container).create()

        self.__context.addStepWithCheckpoint(self.__steps.jython(
            description="Restart Deployment {0} on {1}".format(self.__deployment_helper.get_deployment_name(deployed),
                container_helper.get_container_name(deployed.container)),
            script="xld/kubernetes/deployment/restart_deployment.py",
            jython_context={"deployed": deployed, "previousDeployed": previousDeployed},
            order=deployed.modifyOrder
        ), delta)

        if deployed.minimumPodCount > 0:
            self.__context.addStepWithCheckpoint(self.__steps.jython(
                description="Wait for Deployment {0} to be in running state".format(
                    self.__deployment_helper.get_deployment_name(deployed)),
                script="xld/kubernetes/deployment/wait_for_deployment_ready_on_modify.py",
                jython_context={"deployed": deployed, "previousDeployed": previousDeployed},
                order=deployed.modifyOrder + 1
            ), delta)
