import re
import os.path

from xld.kubernetes.batch_api_client import KubernetesBatchClient

k8s_master = container.getProperty("k8sMaster")
api_client = KubernetesBatchClient(k8s_master)

inspected = inspectionContext.getInspected()
cronjob_ci_list = []

for key in inspected:
    ci = inspected[key]
    if str(ci.type) == 'k8s.Namespace':
        namespaceName = ci.getProperty("namespaceName")
        if ci.getProperty("token"):
            api_client = KubernetesBatchClient(k8s_master, ci.getProperty("token"))
        cronjobs = api_client.get_batch_api().list_namespaced_cron_job(namespace=namespaceName)

        cronjob_list = cronjobs.items
        for cronjob in cronjob_list:
            metadata = cronjob.metadata
            cronjob_name = metadata.name
            cronjob_id = "%s/%s" % (ci.id, cronjob_name)
            cronjob_ci = Type.valueOf("k8s.CronJob").descriptor.newInstance(cronjob_id)

            cronjob_ci.setProperty("cronJobName", cronjob_name)
            cronjob_ci.setProperty("schedule", cronjob.spec.schedule)
            cronjob_ci.setProperty("failedJobsHistoryLimit", cronjob.spec.failed_jobs_history_limit)
            cronjob_ci.setProperty("successfulJobsHistoryLimit", cronjob.spec.successful_jobs_history_limit)
            cronjob_ci.setProperty("startingJobsDeadlineSeconds", cronjob.spec.starting_deadline_seconds)
            cronjob_ci.setProperty("activeJobsDeadlineSeconds", cronjob.spec.job_template.spec.active_deadline_seconds)
            cronjob_ci.setProperty("suspend", cronjob.spec.suspend)
            cronjob_ci.setProperty("backoffLimit", cronjob.spec.job_template.spec.backoff_limit)
            cronjob_ci.setProperty("completions", cronjob.spec.job_template.spec.completions)
            cronjob_ci.setProperty("parallelism", cronjob.spec.job_template.spec.parallelism)
            cronjob_ci.setProperty("concurrencyPolicy", cronjob.spec.concurrency_policy)
            cronjob_ci.setProperty("labels", cronjob.metadata.labels)
            cronjob_ci_list.append(cronjob_ci)
            print("Discovered Cronjob %s in namespace %s" % (cronjob_name, namespaceName))


for ci in cronjob_ci_list:
    inspectionContext.discovered(ci)
    inspectionContext.inspected(ci)
