import re
import os.path

from xld.kubernetes.core_api_client import KubernetesCoreClient

k8s_master = thisCi.getProperty("k8sMaster")

api_client = KubernetesCoreClient(k8s_master)
namespaces_list = api_client.core_api.list_namespace(watch=False)
namespace_name_list = [namespace.metadata.name for namespace in namespaces_list.items]
print "Following namespaces exists on kubernetes cluster: %s" % namespace_name_list

first_context = True
for namespace in namespace_name_list:
    namespace_id = "%s/%s" % (k8s_master.id, namespace)
    if first_context:
        #Use the discovery CI to fill the first context info
        namespace_ci = thisCi
        namespace_ci.id = namespace_id
        namespace_ci.setProperty("namespaceName", namespace)
        namespace_ci.setProperty("k8sMaster", k8s_master)
        first_context = False
        namespace_ci.setProperty("namespaceName", namespace)
    else:
        namespace_ci = Type.valueOf("k8s.Namespace").descriptor.newInstance(namespace_id)
        namespace_ci.setProperty("namespaceName", namespace)
        namespace_ci.setProperty("k8sMaster", k8s_master)
        inspectionContext.discovered(namespace_ci)
        inspectionContext.inspected(namespace_ci)


