from xld.kubernetes.core_api_client import KubernetesCoreClient

k8s_master = container.getProperty("k8sMaster")
api_client = KubernetesCoreClient(k8s_master)

inspected = inspectionContext.getInspected()
volume_claim_ci_list = []

for key in inspected:
    ci = inspected[key]
    if str(ci.type) == 'k8s.Namespace':
        namespaceName = ci.getProperty("namespaceName")
        if ci.getProperty("token"):
            api_client = KubernetesCoreClient(k8s_master, ci.getProperty("token"))

        volume_claim_list = api_client.core_api.list_namespaced_persistent_volume_claim(namespace=namespaceName)

        claim_list = volume_claim_list.items
        for claim in claim_list:
            metadata = claim.metadata
            claim_name = metadata.name
            claim_id = "%s/%s" % (ci.id, claim_name)
            claim_ci = Type.valueOf("k8s.PersistentVolumeClaim").descriptor.newInstance(claim_id)

            claim_ci.setProperty("claimName", claim_name)
            claim_ci.setProperty("volumeName", claim.spec.volume_name)
            claim_ci.setProperty("accessModes", claim.spec.access_modes)
            claim_ci.setProperty("storageClassName", claim.spec.storage_class_name)
            claim_ci.setProperty("limits", claim.spec.resources.limits)
            if claim.spec.resources.requests:
                claim_ci.setProperty("requests", claim.spec.resources.requests)
            if claim.spec.selector and  claim.spec.selector.match_labels:
                claim_ci.setProperty("matchLabels", claim.spec.selector.match_labels)

            volume_claim_ci_list.append(claim_ci)
            print("Discovered VolumeClaim %s in namespace %s" % (claim_name, namespaceName))


for ci in volume_claim_ci_list:
    inspectionContext.discovered(ci)
    inspectionContext.inspected(ci)
