#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import yaml

class text(unicode):
    pass


def text_representer(dumper, data):
    return dumper.represent_scalar('tag:yaml.org,2002:str', data, style='|')

def yaml_safe_dump(_dict):
    yaml.add_representer(text, text_representer,
                         Dumper=yaml.SafeDumper)

    if 'data' in _dict and _dict['data']:
        for i in _dict['data']:
            data = _dict['data'][i]
            _dict['data'][i] = text(data)

    return yaml.safe_dump(_dict, default_flow_style=False).replace("({(", "{{").replace(")})", "}}")

def yaml_safe_dump_preview(_dict):
    yaml.add_representer(text, text_representer,
                         Dumper=yaml.SafeDumper)

    if 'data' in _dict and _dict['data']:
        for i in _dict['data']:
            data = _dict['data'][i]
            if 'kind' in _dict and _dict['kind'].lower() == "secret" :
                _dict['data'][i] = "***********"
            else:
                _dict['data'][i] = text(data)

    return yaml.safe_dump(_dict, default_flow_style=False).replace("({(", "{{").replace(")})", "}}")
