from xld.kubernetes.deployment.deployment_helper import DeploymentHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory

container_helper = ContainerHelperFactory(deployed.container).create()

if deployed.minimumPodCount > deployed.replicasCount:
    raise RuntimeError("Minimum pod count should not be more than replicas count.")

context.addStepWithCheckpoint(steps.jython(
    description="{0} deployment {1} on {2}".format(
        'Modify' if previousDeployed else 'Create', DeploymentHelper().get_deployment_name(deployed),
        container_helper.get_container_name(deployed.container)),
    script="xld/kubernetes/deployment/%s" % ('modify_deployment.py' if previousDeployed else 'create_deployment.py'),
    order=61
), delta)

# Wait only for create deployment
if not previousDeployed and deployed.minimumPodCount > 0:
    context.addStepWithCheckpoint(steps.jython(
        description="Wait for deployment's pods to be in running state",
        script="xld/kubernetes/deployment/wait_for_deployment_creation.py",
        order=62
    ), delta)
