from xld.kubernetes.deployment.deployment_helper import DeploymentHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory

container_helper = ContainerHelperFactory(previousDeployed.container).create()
deployment_name = DeploymentHelper().get_deployment_name(previousDeployed)


context.addStepWithCheckpoint(steps.jython(
    description="Destroy deployment {0} from {1}".format(deployment_name, container_helper.get_container_name(previousDeployed.container)),
    script="xld/kubernetes/deployment/remove_deployment.py",
    order=49
), delta)

# Wait for deployment delete
context.addStepWithCheckpoint(steps.jython(
    description="Wait for deployment {0} to be destroyed completely".format(deployment_name),
    script="xld/kubernetes/deployment/wait_for_deployment_deletion.py",
    order=50
), delta)
