from xld.kubernetes.apps_api_client import KubernetesAppsClient
from xld.kubernetes.deployment.deployment_helper import DeploymentHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory


class DeploymentService(object):
    def __init__(self):
        self.__deployment_helper = DeploymentHelper()

    def create_deployment(self, deployed):
        client = self.__create_client(deployed.container.container)
        request_deployment = self.__deployment_helper.read_deployment(deployed_deployment=deployed)
        container_helper = self.__create_container_helper(deployed.container)
        print("Creating Deployment '{0}' in {1} '{2}' ".format(request_deployment['metadata']['name'],
                                                               container_helper.get_container_label(),
                                                               container_helper.get_container_name(
                                                                   deployed.container)))
        response_deployment = client.create_deployment(request_deployment,
                                                       container_helper.get_container_name(
                                                           deployed.container))
        return response_deployment

    def update_deployment(self, deployed, previousDeployed):
        client = self.__create_client(deployed.container.container)
        request_deployment = self.__deployment_helper.read_deployment(deployed_deployment=deployed)
        container_helper = self.__create_container_helper(deployed.container)
        print("Updating deployment '{0}' in {1} '{2}' ".format(
            self.__deployment_helper.get_deployment_name(previousDeployed),
            container_helper.get_container_label(),
            container_helper.get_container_name(deployed.container)))
        response_deployment = client.replace_deployment(self.__deployment_helper.get_deployment_name(previousDeployed),
                                                        request_deployment,
                                                        container_helper.get_container_name(
                                                            deployed.container))
        return response_deployment

    def destroy_deployment(self, previousDeployed):
        client = self.__create_client(previousDeployed.container.container)
        container_helper = self.__create_container_helper(previousDeployed.container)
        print "Destroying deployment '{0}' from {1} '{2}' ".format(
            self.__deployment_helper.get_deployment_name(previousDeployed),
            container_helper.get_container_label(),
            container_helper.get_container_name(previousDeployed.container))
        client.remove_deployment(self.__deployment_helper.get_deployment_name(previousDeployed),
                                 container_helper.get_container_name(
                                     previousDeployed.container))

    def should_wait_for_deployment_creation(self, deployed):
        client = self.__create_client(deployed.container.container)
        response_deployment = client.read_deployment(self.__deployment_helper.get_deployment_name(deployed),
                                                     self.__create_container_helper(
                                                         deployed.container).get_container_name(deployed.container))
        if response_deployment.status.available_replicas < deployed.minimumPodCount:
            print("Waiting for deployment's pods to be in running state".format(
                self.__deployment_helper.get_deployment_name(deployed)))
            return True
        return False

    def should_wait_for_deployment_deletion(self, previousDeployed):
        client = self.__create_client(previousDeployed.container.container)
        if client.is_deployment_existing(self.__deployment_helper.get_deployment_name(previousDeployed),
                                         self.__create_container_helper(previousDeployed.container).get_container_name(
                                             previousDeployed.container)):
            print "Waiting for deployment {0} to be destroyed.".format(
                self.__deployment_helper.get_deployment_name(previousDeployed))
            return True
        return False

    @staticmethod
    def __create_client(container):
        return KubernetesAppsClient(container)

    @staticmethod
    def __create_container_helper(container):
        return ContainerHelperFactory(container).create()
