import json
from org.apache.commons.io import IOUtils

import yaml
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.factories.handler_factory import ResourceFactoryResolver


class ResourceHelper(object):
    def __init__(self, deployed):
        self.__deployed = deployed
        self.__file_data = deployed.file.getInputStream()
        self.__container_helper = ContainerHelperFactory(deployed.container).create()

    def validate_resource(self):
        valid = ResourceFactoryResolver(self.__deployed) \
            .get_factory() \
            .is_supported(ResourceHelper(self.__deployed).parse())
        if not valid:
            raise RuntimeError("Unsupported resource for {0} {1}".format(self.__container_helper.get_container_label(),
                                                                          self.__container_helper.get_container_name(
                                                                              self.__deployed.container)))

    def parse(self):
        data = self.__get_data()
        try:
            return json.loads(data)
        except:
            try:
                return yaml.safe_load(data)
            except:
                raise

    def __get_data(self):
        try:
            data = IOUtils.toString(self.__file_data, "UTF-8")
            return data
        finally:
            IOUtils.closeQuietly(self.__file_data)
