from xld.kubernetes.factories.handler_factory import ApiClientFactory
from kubernetes import client

class KubernetesBaseClient(object):
    def __init__(self, container):
        self.__container = container
        self.internal_api_client = ApiClientFactory(container).create()

    def get_api_versions(self):
        api_instance = client.ApisApi(self.internal_api_client)
        return api_instance.get_api_versions()
