from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.pod.pod_helper import PodHelper

container_helper = ContainerHelperFactory(previousDeployed.container).create()

context.addStepWithCheckpoint(steps.jython(
    description="Destroy Pod {0} from {1}".format(PodHelper.get_pod_name(previousDeployed), container_helper.get_container_name(previousDeployed.container)),
    script="xld/kubernetes/pod/remove_pod.py",
    order=49
), delta)

context.addStepWithCheckpoint(steps.jython(
    description="Wait for Pod {0} to be destroyed completely".format(PodHelper.get_pod_name(previousDeployed)),
    script="xld/kubernetes/pod/wait_for_pod_deletion.py",
    order=50
), delta)
