from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.pod.pod_helper import PodHelper

container_helper = ContainerHelperFactory(deployed.container).create()

if PodHelper.get_pod_name(previousDeployed) != PodHelper.get_pod_name(deployed):
    raise RuntimeError('Pod name should not be modified.')

context.addStepWithCheckpoint(steps.jython(
    description="Destroy Pod {0} from {1}".format(PodHelper.get_pod_name(previousDeployed), container_helper.get_container_name(previousDeployed.container)),
    script="xld/kubernetes/pod/remove_pod.py",
    order=49
), delta)

context.addStepWithCheckpoint(steps.jython(
    description="Wait for Pod {0} to be destroyed completely".format(PodHelper.get_pod_name(previousDeployed)),
    script="xld/kubernetes/pod/wait_for_pod_deletion.py",
    order=50
), delta)


context.addStepWithCheckpoint(steps.jython(
    description="Create Pod {0} on {1} {2}".format(PodHelper.get_pod_name(deployed),
                                                   container_helper.get_container_label(),
                                                   container_helper.get_container_name(deployed.container)),
    script="xld/kubernetes/pod/create_pod.py",
    order=61
), delta)

context.addStepWithCheckpoint(steps.jython(
    description="Wait for Pod {0} to be in running state".format(PodHelper.get_pod_name(deployed)),
    script="xld/kubernetes/pod/wait_for_pod_creation.py",
    order=62
), delta)
