#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.factories.handler_factory import ApiClientFactory
from kubernetes import client


class KubernetesBaseClient(object):
    def __init__(self, container):
        self.__container = container
        self.internal_api_client = ApiClientFactory(container).create()

    def get_code_version(self):
        api_instance = client.VersionApi(self.internal_api_client)
        return api_instance.get_code()
