#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from kubernetes import client
from xld.kubernetes import KubernetesBaseClient


class KubernetesBatchClient(KubernetesBaseClient):
    def __init__(self, container):
        super(KubernetesBatchClient, self).__init__(container)

    def get_batch_api(self):
        print ("[Using API version: {}]".format(self.get_api_version()))
        return client.BatchV1beta1Api(self.internal_api_client)

    @staticmethod
    def get_api_version():
        return "batch/v1beta1"

    def read_cronjob(self, name, namespace):
        return self.get_batch_api().read_namespaced_cron_job(name=name, namespace=namespace)

    def create_cronjob(self, v1_cronjob, namespace):
        return self.get_batch_api().create_namespaced_cron_job(namespace=namespace, body=v1_cronjob)

    def remove_cronjob(self, name, namespace):
        body = client.V1DeleteOptions(orphan_dependents=False, grace_period_seconds=0)
        return self.get_batch_api().delete_namespaced_cron_job(name=name, body=body, namespace=namespace)

    def replace_cronjob(self, name, v1_cronjob, namespace):
        return self.get_batch_api().replace_namespaced_cron_job(namespace=namespace, body=v1_cronjob, name=name)
