#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
from kubernetes import client


def get_client_for_api_version(api_client, api_version):

    api_version_clients = {"admissionregistration.k8s.io/v1alpha1": client.AdmissionregistrationV1alpha1Api,
                           "apiextensions.k8s.io/v1beta1": client.ApiextensionsV1beta1Api,
                           "apiregistration.k8s.io/v1beta1": client.ApiregistrationV1beta1Api,
                           "v1": client.CoreV1Api,
                           "apps/v1beta1": client.AppsV1beta1Api,
                           "apps/v1beta2": client.AppsV1beta2Api,
                           "authentication.k8s.io/v1": client.AuthenticationV1Api,
                           "authentication.k8s.io/v1beta1": client.AuthenticationV1beta1Api,
                           "authorization.k8s.io/v1": client.AuthorizationV1Api,
                           "authorization.k8s.io/v1beta1": client.AuthorizationV1beta1Api,
                           "autoscaling/v1": client.AutoscalingV1Api,
                           "autoscaling/v2beta1": client.AutoscalingV2beta1Api,
                           "batch/v1": client.BatchV1Api,
                           "batch/v1beta1": client.BatchV1beta1Api,
                           "batch/v2alpha1": client.BatchV2alpha1Api,
                           "certificates.k8s.io/v1beta1": client.CertificatesV1beta1Api,
                           "extensions/v1beta1": client.ExtensionsV1beta1Api,
                           "networking.k8s.io/v1": client.NetworkingV1Api,
                           "policy/v1beta1": client.PolicyV1beta1Api,
                           "rbac.authorization.k8s.io/v1": client.RbacAuthorizationV1Api,
                           "rbac.authorization.k8s.io/v1alpha1": client.RbacAuthorizationV1alpha1Api,
                           "storage.k8s.io/v1": client.StorageV1Api,
                           "storage.k8s.io/v1beta1": client.StorageV1beta1Api
                          }
    return api_version_clients[api_version](api_client)

