#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.commons.common_utils import CommonUtils
from xld.kubernetes.core_api_client import KubernetesCoreClient
from xld.kubernetes.service.service_helper import ServiceHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory


class ServiceService(object):

    def __init__(self):
        self.__service_helper = ServiceHelper()
        self.__kind = CommonUtils.get_kind(self)

    def create_service(self, deployed):
        client = self.__create_client(deployed.container.container)
        service_request = self.__service_helper.read_service(deployed_service=deployed)
        container_helper = self.__create_container_helper(deployed.container)
        print("Creating Service '{0}' in {1} '{2}' ".format(self.__service_helper.get_service_name(deployed),
                                                            container_helper.get_container_label(),
                                                            container_helper.get_container_name(
                                                                deployed.container)))
        CommonUtils.print_request_dump(deployed.container.container, service_request, self.__kind,
                                       client.get_api_version())
        service_response = client.create_service(service_request, container_helper.get_container_name(
                                                     deployed.container))
        CommonUtils.print_response_dump(deployed.container.container, service_response)
        return service_response

    def update_service(self, deployed, previousDeployed):
        client = self.__create_client(deployed.container.container)
        service_request = self.__service_helper.read_service(deployed_service=deployed)
        container_helper = self.__create_container_helper(deployed.container)
        print("Updating Service '{0}' in {1} '{2}' ".format(
            self.__service_helper.get_service_name(previousDeployed),
            container_helper.get_container_label(),
            container_helper.get_container_name(deployed.container)))
        CommonUtils.print_request_dump(deployed.container.container, service_request, self.__kind,
                                       client.get_api_version())
        self.__service_helper.read_output_properties(service_request, previousDeployed)
        service_response = client.replace_service(self.__service_helper.get_service_name(previousDeployed),
                                                  service_request, container_helper.get_container_name(
                                                      deployed.container))
        CommonUtils.print_response_dump(deployed.container.container, service_response)
        return service_response

    def destroy_service(self, previousDeployed):
        client = self.__create_client(previousDeployed.container.container)
        container_helper = self.__create_container_helper(previousDeployed.container)
        print("Destroying Service '{0}' from {1} '{2}' ".format(
            self.__service_helper.get_service_name(previousDeployed),
            container_helper.get_container_label(),
            container_helper.get_container_name(previousDeployed.container)))
        client.remove_service(self.__service_helper.get_service_name(previousDeployed),
                              container_helper.get_container_name(
                                  previousDeployed.container))

    def should_wait_for_service_creation(self, deployed):
        client = self.__create_client(deployed.container.container)
        if not client.is_service_existing(self.__service_helper.get_service_name(deployed),
                                      self.__create_container_helper(deployed.container)
                                          .get_container_name(deployed.container)):
            print("Waiting for Service {0} to be created.".format(
                self.__service_helper.get_service_name(deployed)))
            return True
        return False

    def should_wait_for_service_deletion(self, previousDeployed):
        client = self.__create_client(previousDeployed.container.container)
        if client.is_service_existing(self.__service_helper.get_service_name(previousDeployed),
                                      self.__create_container_helper(previousDeployed.container).get_container_name(
                                          previousDeployed.container)):
            print("Waiting for Service {0} to be destroyed.".format(
                self.__service_helper.get_service_name(previousDeployed)))
            return True
        return False

    @staticmethod
    def __create_client(container):
        return KubernetesCoreClient(container)

    @staticmethod
    def __create_container_helper(container):
        return ContainerHelperFactory(container).create()
