#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys
from xld.kubernetes import *

print "------------------"
print "Testing connection to Kubernetes Cluster {0}".format(thisCi.name)
print "------------------"
try:
    client = KubernetesBaseClient(thisCi)
    versions = client.get_code_version()
    if versions is None:
        raise RuntimeError("Connection Unsuccessful !")
    print "Connection Successful !"
except Exception as e:
    message = ""
    if not ((thisCi.tlsCert and thisCi.tlsPrivateKey) or (thisCi.token) or
                (thisCi.username and thisCi.password)):
        message = "Authentication information is missing. "

    print "Connection Failed: {0}{1}".format(message, str(e))
    sys.exit(1)
