#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory, ResourceFactoryResolver

result = "SUCCESS"
container_helper = ContainerHelperFactory(deployed.container).create()
provider = ResourceFactoryResolver(deployed).get_factory().get(data)
resources = provider.filter_resources_by_definition(namespace=container_helper.get_container_name(deployed.container),
                                                    resource_definition=data)

for statefulset in resources.items:
    minimum_pod_count = 1
    if statefulset.status.readyReplicas < minimum_pod_count:
        print("Waiting for StatefulSet's pod {0} to be in running state".format(data['metadata']['name']))
        result = "RETRY"

