#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.storage_class.helper import StorageClassHelper

context.addStepWithCheckpoint(steps.jython(
    description="Destroy StorageClass {} from {}".format(StorageClassHelper.get_name(previousDeployed),
                                                       previousDeployed.container.name),
    script="xld/kubernetes/storage_class/steps/destroy.py",
    order=48
), delta)

context.addStep(steps.jython(
    description="Wait for StorageClass {} to be destroyed completely".format(StorageClassHelper.
                                                                             get_name(previousDeployed)),
    script="xld/kubernetes/storage_class/steps/wait_for_destroy.py",
    order=49
))
