import json
import yaml
from xld.yaml.dumper import yaml_safe_dump

from com.xebialabs.deployit.plugin.api.reflect import Type


class GenerateDeployables(object):
    def __init__(self, ci_id, vars):
        self.ci_id = ci_id
        self.repo = vars['repositoryService']
        self.template_path = self.repo.read(ci_id).file.path
        self.resource_descriptor = Type.valueOf("k8s.Descriptor").descriptor

    def create_resource(self, _name, _content):
        ci = self.resource_descriptor.newInstance(
            "%s/%s" % (self.ci_id, _name))
        ci.setProperty('content', _content)
        print "Creating CI: %s" % ci.id
        self.repo.create([ci])

    def process(self):
        template = Template(self.template_path)
        index = 1
        for obj in template.dict:
            name = str(index)
            if 'metadata' in obj:
                if 'name' in obj['metadata']:
                    name = obj['metadata']['name']
            self.create_resource(obj['kind'] + '-' + name, template.dump(obj))
            index = index + 1


class Template(object):
    def __init__(self, path):
        with open(path, 'r') as f:
            # Adding quotes safely in case there are placeholders '{{ }}' in the yaml file
            data = f.read().replace("{{", "\"{{").replace("}}", "}}\"") \
                .replace("\"\"{{", "\"{{").replace("}}\"\"", "}}\"")
        self.is_json = True
        if path.endswith('yaml') or path.endswith('yml'):
            self.dict = yaml.safe_load_all(data)
            self.is_json = False
        else:
            self.dict = json.loads(data)

    def dump(self, _dict):
        if self.is_json:
            return json.dumps(_dict, indent=4, sort_keys=True)
        else:
            return yaml_safe_dump(_dict)


GenerateDeployables(thisCi.id, locals()).process()
