#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.batch_api_client import KubernetesBatchClient
from xld.kubernetes.commons.common_utils import CommonUtils
from xld.kubernetes.cronjob.cronjob_helper import CronJobHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory


class CronJobService(object):

    def __init__(self):
        self.__cronjob_helper = CronJobHelper()
        self.__kind = CommonUtils.get_kind(self)

    def create_cronjob(self, deployed):
        with self.__create_client(deployed.container.container) as client:
            request_cronjob = self.__cronjob_helper.read_cronjob(deployed_cronjob=deployed)
            container_helper = self.__create_container_helper(deployed.container)
            print("Creating CronJob '{0}' in {1} '{2}' ".format(request_cronjob['metadata']['name'],
                                                                container_helper.get_container_label(),
                                                                container_helper.get_container_name(deployed.container)))
            CommonUtils.print_request_dump(deployed.container.container, request_cronjob, self.__kind,
                                           client.get_api_version())
            response_cronjob = client.create_cronjob(request_cronjob,
                                                           container_helper.get_container_name(
                                                               deployed.container))
        CommonUtils.print_response_dump(deployed.container.container, response_cronjob)
        return response_cronjob

    def update_cronjob(self, deployed, previousDeployed):
        with self.__create_client(deployed.container.container) as client:
            request_cronjob = self.__cronjob_helper.read_cronjob(deployed_cronjob=deployed)
            container_helper = self.__create_container_helper(deployed.container)
            print("Updating CronJob '{0}' in {1} '{2}' ".format(
                self.__cronjob_helper.get_cronjob_name(previousDeployed),
                container_helper.get_container_label(),
                container_helper.get_container_name(deployed.container)))
            CommonUtils.print_request_dump(deployed.container.container, request_cronjob, self.__kind,
                                           client.get_api_version())

            response_cronjob = client.replace_cronjob(self.__cronjob_helper.get_cronjob_name(previousDeployed),
                                                      request_cronjob,
                                                      container_helper.get_container_name(deployed.container))
        CommonUtils.print_response_dump(deployed.container.container, response_cronjob)
        return response_cronjob

    def destroy_cronjob(self, previousDeployed):
        with self.__create_client(previousDeployed.container.container) as client:
            container_helper = self.__create_container_helper(previousDeployed.container)
            print "Destroying CronJob '{0}' from {1} '{2}' ".format(
                self.__cronjob_helper.get_cronjob_name(previousDeployed),
                container_helper.get_container_label(),
                container_helper.get_container_name(previousDeployed.container))
            client.remove_cronjob(self.__cronjob_helper.get_cronjob_name(previousDeployed),
                                  container_helper.get_container_name(previousDeployed.container))

    def is_present(self, deployed):
        container_helper = self.__create_container_helper(deployed.container)
        with self.__create_client(deployed.container.container) as client:
            response = client.get_batch_api().list_namespaced_cron_job(
                namespace=container_helper.get_container_name(deployed.container),
                field_selector="metadata.name={}".format(CronJobHelper.get_cronjob_name(deployed)))
        if len(response.items) > 0:
            return True
        return False

    @staticmethod
    def __create_client(container):
        return KubernetesBatchClient(container)

    @staticmethod
    def __create_container_helper(container):
        return ContainerHelperFactory(container).create()
