#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.persistent_volume_claim.helper import PVCHelper

container_helper = ContainerHelperFactory(deployed.container).create()

context.addStepWithCheckpoint(steps.jython(
    description="Create PersistentVolumeClaim {} on {}".format(
        PVCHelper.get_name(deployed),
        container_helper.get_container_name(deployed.container)),
    script="xld/kubernetes/persistent_volume_claim/steps/create.py",
    order=59
), delta)

context.addStep(steps.jython(
    description="Wait for PersistentVolumeClaim to be in bound phase",
    script="xld/kubernetes/persistent_volume_claim/steps/wait_for_creation.py",
    order=60
))
