#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.config_map.helper import ConfigMapHelper
from xld.kubernetes.pod.planningScripts.pod_steps_generator import PodsStepsGenerator
from xld.kubernetes.deployment.planningScripts.deployment_steps_generator import DeploymentStepsGenerator
from xld.kubernetes.statefulset.planningScripts.statefulset_steps_generator import StatefulSetStepsGenerator

config_maps = filter(
    lambda delta: delta.operation == "MODIFY" and (delta.deployedOrPrevious.type == "k8s.ConfigMap"),
    deltas.deltas)
for delta_config_map in config_maps:
    container_helper = ContainerHelperFactory(delta_config_map.deployed.container).create()
    if delta_config_map.deployed.configMapName != delta_config_map.previous.configMapName:
        raise RuntimeError('Name of ConfigMap cannot be modified.')
    context.addStepWithCheckpoint(steps.jython(
        description="Modify ConfigMap {} on {}".format(ConfigMapHelper().get_config_map_name(delta_config_map.deployed),
                                                       container_helper.get_container_name(
                                                           delta_config_map.deployed.container)),
        script="xld/kubernetes/config_map/modify.py",
        jython_context={"deployed": delta_config_map.deployed, "previousDeployed": delta_config_map.previous},
        order=59,
        preview_script="xld/kubernetes/config_map/preview.py"
    ), delta_config_map)

pod_candidates = ConfigMapHelper.get_referenced_resources(config_maps, deltas, 'k8s.Pod')
pod_steps_generator = PodsStepsGenerator(context, steps)
for pod_candidate in pod_candidates:
    pod_steps_generator.replace(pod_candidate, pod_candidate.deployed, pod_candidate.previous)

deployment_candidates = ConfigMapHelper.get_referenced_resources(config_maps, deltas, 'k8s.Deployment')
deployment_steps_generator = DeploymentStepsGenerator(context, steps)
for deployment_candidate in deployment_candidates:
    deployment_steps_generator.replace(deployment_candidate, deployment_candidate.deployed,
                                       deployment_candidate.previous)

statefulset_candidates = ConfigMapHelper.get_referenced_resources(config_maps, deltas, 'k8s.StatefulSet')
statefulset_steps_generator = StatefulSetStepsGenerator(context, steps)
for statefulset_candidate in statefulset_candidates:
    statefulset_steps_generator.replace(statefulset_candidate, statefulset_candidate.deployed,
                                        statefulset_candidate.previous)
