#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.config_map.helper import ConfigMapHelper

container_helper = ContainerHelperFactory(previousDeployed.container).create()

context.addStepWithCheckpoint(steps.jython(
    description="Destroy ConfigMap {} from {}".format(ConfigMapHelper().get_config_map_name(previousDeployed),
                                                      container_helper.get_container_name(previousDeployed.container)),
    script="xld/kubernetes/config_map/destroy.py",
    order=previousDeployed.destroyOrder
), delta)

context.addStep(steps.jython(
    description="Wait for ConfigMap to be destroyed completely",
    script="xld/kubernetes/config_map/wait_for_destroy.py",
    order=previousDeployed.destroyOrder + 1
))
