;(function(){

'use strict';

angular.module('xld.templates.application', []).run(['$templateCache', function($templateCache) {

  $templateCache.put('application/applications.html', '<div class="xl-deploy-space xl-applications"><xl-notify-view></xl-notify-view><div class="part detail"><div class="xl-tabs"><div tab-header></div></div><div tab-view></div></div></div>');

  $templateCache.put('application/tabs/empty.html', '<div class="empty-tab"></div>');

  $templateCache.put('application/tabs/applications/application-ci.html', '<div class="content" id="application-tab"><div class="xl-row"><div class="xl-column-main"><div class="xl-form-wrapper" ng-show="isLoaded()"><form name="newApplicationForm" id="new-application-form" class="form-horizontal" role="form"><div ng-switch on="$tabData.mode"><h4 ng-switch-when="edition">{{ \'terminology.editApplication\' | i18n }}</h4><h4 ng-switch-default>{{ \'terminology.application\' | i18n }}</h4></div><p>{{ \'terminology.applicationDescription\' | i18n }}</p><div class="xl-container xl-container-margin-top selected-containers xl-container-top-triangle xl-container-top-triangle-10"><div class="input-component"><div class="input-label"><label for="application-path">{{ \'terminology.applicationPath\' | i18n }}</label></div><!--\n             --><div class="input-form"><input ng-show="$tabData.mode !== \'visual\'" type="text" id="application-path" name="applicationPath" class="form-control input-sm" ng-model="$tabData.applicationPath" xl-autocomplete="getDirectoriesMatching($tabData.applicationPath)" placeholder="For example your folder/another folder" ng-disabled="$tabData.mode===\'edition\'"> <span ng-show="$tabData.mode !== \'visual\'" class="xl-field-description">{{ \'terminology.applicationPathDescription\' | i18n }}</span><div id="xl-directory-error" ng-show="$tabData.postDirectoryError" xl-widget-alert-message on-dismiss="$tabData.postDirectoryError=undefined">{{ $tabData.postDirectoryError }}</div><label ng-show="$tabData.mode===\'visual\'" for="application-path">{{ $tabData.applicationPath }}</label></div></div><div class="input-component"><div class="input-label"><label for="application-name">{{ \'terminology.applicationName\' | i18n }}</label></div><!--\n             --><div class="input-form"><input ng-show="$tabData.mode !== \'visual\'" type="text" name="applicationName" id="application-name" class="form-control input-sm" ng-model="$tabData.applicationName" ng-disabled="$tabData.mode===\'edition\'" ng-change="$tabData.postApplicationsError=\'\'" required><div id="xl-application-name-error" ng-show="$tabData.postApplicationsError" xl-widget-alert-message on-dismiss="$tabData.postApplicationsError=undefined">{{ $tabData.postApplicationsError }}</div><label ng-show="$tabData.mode===\'visual\'" for="application-name">{{$tabData.applicationName}}</label></div></div><div class="input-component"><div class="input-label"><label>{{ \'terminology.applicationType\' | i18n }}</label></div><!--\n             --><div class="input-form"><p class="form-control-static">{{ \'terminology.applicationTypeName\' | i18n }}</p></div></div></div></form><div xl-dip-dynamic-form ng-model="$tabData.application" form-model="applicationDynamicFormModel" metadata="applicationMetadata" handlers="dipHandlers.formHandlers" display-mode="$tabData.mode"></div><div class="xl-button-container"><button id="cancelAndView" class="xl-button xl-cancel" ng-if="$tabData.mode===\'edition\'" ng-click="switchToViewApplicationWithConfirm()">{{ \'terminology.cancelButton\' | i18n }}</button> <button id="save" class="xl-button xl-primary" ng-if="$tabData.mode===\'edition\'" ng-click="saveApplicationAndDirectories(switchToViewApplication)" ng-disabled="!isValid()">{{ \'terminology.updateButton\' | i18n }}</button> <button id="editMode" class="xl-button xl-primary" ng-if="$tabData.mode === \'visual\'" ng-click="editApplication()">{{ \'terminology.editButton\' | i18n }}</button></div></div></div></div></div>');

  $templateCache.put('application/tabs/deployable/deployable.html', '<div class="content" id="deployable-tab"><div class="xl-row"><div class="xl-column-main"><div class="xl-form-wrapper" ng-show="isLoaded()"><form name="newDeployableForm" id="new-deployable-form" class="form-horizontal" role="form"><div ng-switch on="$tabData.mode"><h4 ng-switch-when="edition">{{ \'terminology.editDeployableTitle\' | i18n }}</h4><h4 ng-switch-default>{{ \'terminology.deployableTitle\' | i18n }}</h4></div><p>{{ \'terminology.deployableDescription\' | i18n }}</p><div class="xl-container xl-container-margin-top selected-containers xl-container-top-triangle xl-container-top-triangle-10"><div class="input-component"><div class="input-label"><label for="deployable-path" class="">{{ \'terminology.deployablePath\' | i18n }}</label></div><!--\n         --><div class="input-form"><input ng-show="$tabData.mode !== \'visual\'" type="text" id="deployable-path" name="deployablePath" class="form-control input-sm" ng-model="$tabData.deployablePath" placeholder="Deployable path" disabled="disabled"><label ng-show="$tabData.mode===\'visual\'" for="deployable-path">{{$tabData.deployablePath}}</label></div></div><div class="input-component"><div class="input-label"><label for="deployable-name" class="">{{ \'terminology.deployableName\' | i18n }}</label></div><!--\n         --><div class="input-form"><input ng-show="$tabData.mode !== \'visual\'" type="text" id="deployable-name" name="deployableName" class="form-control input-sm" ng-model="$tabData.deployableName" placeholder="Deployable name" ng-disabled="$tabData.mode === \'edition\'" required><label ng-show="$tabData.mode===\'visual\'" for="deployable-name">{{$tabData.deployableName}}</label></div></div><div class="input-component"><div class="input-label"><label for="deployable-type" class="">{{ \'terminology.deployableType\' | i18n }}</label></div><!--\n         --><div class="input-form"><input ng-show="$tabData.mode !== \'visual\'" type="text" name="deployableType" id="deployable-type" class="form-control input-sm" ng-model="$tabData.deployableType" ng-disabled="$tabData.mode === \'edition\'"><label ng-show="$tabData.mode===\'visual\'" for="deployable-type">{{$tabData.deployableType}}</label></div></div></div></form><div id="xlDeployableTypeForm" xl-dip-dynamic-form ng-model="$tabData.deployableTypeFormData" form-model="deployableTypeFormValidation" metadata="$tabData.deployableTypeFormMetadata" handlers="dipHandlers.formHandlers" display-mode="$tabData.mode"></div><div class="xl-button-container"><button id="cancelAndView" class="xl-button xl-cancel" ng-if="$tabData.mode===\'edition\'" ng-click="switchToViewDeployableWithConfirm()">{{ \'terminology.cancelButton\' | i18n }}</button> <button id="save" class="xl-button xl-primary" ng-if="$tabData.mode === \'edition\'" ng-click="saveDeployable(switchToViewDeployable)" ng-disabled="!isValid()">{{ \'terminology.updateButton\' | i18n }}</button> <button id="edit" class="xl-button xl-primary" ng-if="$tabData.mode === \'visual\'" ng-click="editDeployable()">{{ \'terminology.editButton\' | i18n }}</button></div></div></div></div></div>');

  $templateCache.put('application/tabs/deployment-package/deployment-package.html', '<div class="content" id="deployment-package-tab"><div class="xl-row"><div class="xl-column-main"><div class="xl-form-wrapper"><form name="vm.newDeploymentPackageForm" id="new-deployment-package-form" class="form-horizontal" role="form"><h4>{{ \'terminology.deploymentPackageTitle\' | i18n }}</h4><p>{{ \'terminology.deploymentPackageDescription\' | i18n }}</p><br><div class="xl-container"><div class="input-component"><div xl-dip-ci ng-model="vm.existingApplicationName" handlers="vm.existingApplicationNameHandlers" metadata="{name: \'deploymentPackageName\', label: \'Name\', required: true}" is-required="true" display-mode="vm.mode" obj-label="id" is-disabled="vm.showDeploymentDetails"></div></div><div class="input-component"><div xl-dip-string ng-model="vm.applicationVersion" metadata="{name: \'applicationVersion\', label: \'Version\', required: true, placeholder: \'For example 1.0\'}" is-disabled="vm.showDeploymentDetails" display-mode="vm.mode"></div><div id="xl-error" ng-show="vm.postError" xl-widget-alert-message on-dismiss="vm.postError=undefined">{{ postError }}</div><div class="loading-data" ng-hide="vm.versionTypeFormMetadata">{{ \'terminology.waitingLoadingDataMessage\' | i18n }}</div></div></div><div class="xl-button-container" ng-if="vm.mode != \'visual\'"><button id="cancelAndClose" type="button" class="xl-button xl-cancel" ng-if="!vm.showDeploymentDetails" close-ui-tab>{{ \'terminology.cancelButton\' | i18n }}</button> <button id="createAndConfiguration" class="xl-button xl-primary" ng-click="vm.createAndConfigure()" ng-disabled="vm.isCreateAndConfigurationDisabled()">{{ \'terminology.createPackageAndDeployablesButton\' | i18n }}</button></div><div class="deployables-and-advanced" ng-if="vm.showEditPackageOptions"><div ng-if="!vm.showDeploymentDetails" class="deployables-and-advanced-overlay xl-container-top-triangle xl-container-top-triangle-80"></div><div class="xl-container xl-container-margin-top xl-container-top-triangle xl-container-top-triangle-80"><h4>{{ \'terminology.configureDeployablesTitle\' | i18n:{1: vm.existingApplicationName.id, 2 :vm.applicationVersion} }}</h4><div class="deployable-artifact">filesToDeploy<h5>{{ \'terminology.filesToDeployTitle\' | i18n }}</h5><div class="input-component input-deployable" data-ng-repeat="artifact in vm.deployableArtifacts"><div class="details"><span class="name">{{artifact.name}}</span> <a href="#" class="inline-btn delete" ng-click="vm.deleteDeployableArtifact(artifact.ciId.id)" ng-if="artifact.uploaded && mode != \'visual\'"><span>{{ \'terminology.deleteButton\' | i18n }}</span></a> <a href="#" class="inline-btn edit" ng-if="artifact.uploaded && mode != \'visual\'" ng-click="vm.editDeployableArtifact(artifact.ciId.id)"><span>{{ \'terminology.editButton\' | i18n }}</span></a><div ng-if="artifact.progress"><div xl-widget-progressbar current-progress="artifact.progress" options="{maxValue: artifact.fileSize, cancel: artifact.onCancelUpload, stripped: artifact.stripped}" status="artifact.progressStatus"></div><span class="xl-field-description" ng-if="!artifact.form.fileUri">{{vm.showProgressMessage(artifact)}}</span></div></div></div><div class="xl-button-container" ng-if="vm.mode != \'visual\'"><button class="xl-button xl-secondary" ng-click="vm.addDeployableArtifact()" ng-disabled="!vm.showDeploymentDetails">{{ \'terminology.addFileButton\' | i18n }}</button></div></div><div class="deployable-resource"><h5>{{ \'terminology.middlewareConfigurationTitle\' | i18n }}</h5><div class="input-component input-deployable" data-ng-repeat="resource in vm.deployableResources"><div class="details"><span class="name">{{resource.name}}</span> <a href="#" class="inline-btn delete" ng-click="vm.deleteDeployableResource(resource.ciId.id)" ng-if="vm.mode != \'visual\'"><span>{{ \'terminology.deleteButton\' | i18n }}</span></a> <a href="#" class="inline-btn edit" ng-click="vm.editDeployableResource(resource.ciId.id)" ng-if="vm.mode != \'visual\'"><span>{{ \'terminology.editButton\' | i18n }}</span></a></div></div><div class="xl-button-container" ng-if="mode != \'visual\'"><button class="xl-button xl-secondary" ng-click="vm.addDeployableResource()" ng-disabled="!vm.showDeploymentDetails">{{ \'terminology.addResourceButton\' | i18n }}</button></div></div></div><div ng-if="showEditPackageOptions" id="xlVersionTypeForm" xl-dip-dynamic-form ng-model="vm.versionPropertiesFormData" form-model="vm.versionTypeFormValidation.form" metadata="vm.versionTypeFormMetadata" handlers="vm.dipHandlers.formHandlers" display-mode="vm.mode" collapsed="false"></div><div ng-show="vm.configurationError" xl-widget-alert-message on-dismiss="vm.configurationError=undefined">{{ vm.configurationError }}</div><div class="xl-button-container"><button id="editMode" type="button" class="xl-button xl-primary" ng-disabled="vm.isUploading()" ng-click="vm.editDeployablePackage()" ng-if="vm.mode === \'visual\'">{{ \'terminology.editButton\' | i18n }}</button> <button id="cancelAndClose1" type="button" class="xl-button xl-cancel" ng-disabled="vm.isUploading()" close-ui-tab ng-if="vm.mode === \'creation\'">{{ \'terminology.cancelButton\' | i18n }}</button> <button id="cancelAndClose2" type="button" class="xl-button xl-cancel" ng-disabled="vm.isUploading() || !showDeploymentDetails" ng-click="vm.cancelVersionProperties()" ng-if="vm.mode === \'edition\'">{{ \'terminology.cancelButton\' | i18n }}</button> <button id="finishConfiguration" class="xl-button xl-primary" ng-click="vm.saveVersionProperties()" ng-if="vm.mode !== \'visual\'" ng-disabled="vm.versionTypeFormValidation.form.$invalid || vm.isUploading() || !vm.showDeploymentDetails">{{ \'terminology.finishConfiguringButton\' | i18n }}</button></div></div></form></div></div><!--\n\n---><div class="xl-column-aside" xl-sticky-parent><div class="xl-help-block" xl-sticky><h4>{{ \'terminology.helpTitle\' | i18n }}</h4><p>To create a deployment package:</p><ol><li>Provide an application name and version, then click Create.</li><li>To add physical files (artifacts), click Add File. You will be asked to provide:<ul><li>The file itself or its location in an external repository</li><li>A name for the file (if you do not want to use the original file name)</li><li>The configuration item type that describes the file</li><li>Additional properties based on the configuration item type</li></ul></li><li>To add middleware resources, click Add resource. You will be asked to provide:<ul><li>A name for the resource</li><li>The configuration item type that describes the resource</li><li>Additional properties based on the configuration item type</li></ul></li><li>Optionally specify one or more orchestrators to use when deploying this package.</li><li>Optionally specify versions of other applications on which this package depends.</li><li>Click Finish Configuring to save the deployment package.</li></ol></div></div></div></div>');

  $templateCache.put('application/tabs/import/import.html', '<div class="content" id="import-tab"><div class="xl-row"><div class="xl-column-main"><form name="importPackageForm" id="new-import-package-form" class="form-horizontal" role="form"><div accordion close-others="oneAtATime"><div id="importFromUrl" accordion-group is-open="true" is-disabled="vm.uploadFromURLState.state === \'importing\'"><div accordion-heading><span><i class="glyphicon"></i> {{ \'terminology.importFromUrlTitle\' | i18n }}</span></div><p>{{ \'terminology.importFromUrlDescription\' | i18n }}</p><div xl-widget-string ng-model="vm.importObject.fromUrl.model" options="{label: \'URL\', name: \'fromUrlModel\', required: true}"></div><div xl-widget-string ng-model="vm.importObject.fromUrl.user" options="{label: \'User\', name: \'fromUrlUserName\', required: false}"></div><div xl-widget-string ng-model="vm.importObject.fromUrl.password" options="{label: \'Password\', name: \'fromUrlPassword\', required: false, password: true}"></div><span ng-if="uploadError" class="xl-field-description form-error">{{ uploadError }}</span><div class="import-button-holder"><button class="xl-button xl-primary btn pull-right" ng-click="vm.importUrl()" ng-disabled="vm.importObject.fromUrl.model===\'\' || vm.importObject.fromUrl.model === undefined">{{ \'terminology.importButton\' | i18n }}</button></div><div xl-widget-progressbar current-progress="100" options="{stripped: true}" ng-show="vm.importObject.fromUrl.state === \'importing\' "></div><div id="xl-import-form-url-error" ng-show="vm.importObject.fromUrl.state === \'error\' || vm.importObject.fromUrl.state === \'success\'" state="vm.importObject.fromUrl.state" xl-widget-alert-message on-dismiss="vm.importObject.fromUrl.state=undefined; vm.importObject.fromUrl.message=undefined">{{ vm.importObject.fromUrl.message }}</div></div><div id="importFromDisk" accordion-group class="panel-default"><div accordion-heading><span><i class="glyphicon"></i> {{ \'terminology.importFromYourComputer\' | i18n }}</span></div><p>{{ \'terminology.importPackageFromYourComputer\' | i18n }}</p><div xl-widget-file-upload options="vm.fileUploadOptions" ng-model="vm.importObject.fromDisk.model"></div></div><div id="importFromServer" accordion-group class="panel-default" is-disabled="vm.importObject.fromServer.state === \'importing\'"><div accordion-heading><span><i class="glyphicon"></i> {{ \'terminology.importFromServer\' | i18n }}</span></div><p>{{ \'terminology.importFromServerDescription\' | i18n }}</p><div class="input-form"><div class="xl-import-autocomplete-width" xl-widget-autocomplete ng-model="vm.importObject.fromServer.model" handlers="vm.autocompleteImportHandlers" select-mode="true"></div><button id="importServer" class="xl-button xl-primary" ng-click="vm.importPackageFromServer()" ng-disabled="vm.importObject.fromServer.model===\'\' || vm.importObject.fromServer.model===null || vm.importObject.fromServer.model===undefined">{{ \'terminology.importButton\' | i18n }}</button><div xl-widget-progressbar current-progress="100" options="{stripped: true}" ng-show="vm.importObject.fromServer.state === \'importing\' "></div></div><div id="xl-import-form-server-error" ng-show="vm.importObject.fromServer.state === \'error\' || vm.importObject.fromServer.state === \'success\'" state="vm.importObject.fromServer.state" xl-widget-alert-message on-dismiss="vm.importObject.fromServer.state=undefined; vm.importObject.fromServer.message=undefined">{{ vm.importObject.fromServer.message }}</div></div><div class="xl-button-container"><button id="cancel" class="xl-button xl-cancel xl-no-padding" close-ui-tab>{{ \'terminology.closeButton\' | i18n }}</button></div></div></form></div></div></div>');

  $templateCache.put('application/tabs/welcome/welcome.html', '<div class="header"></div><div class="content" id="welcome-tab"><div class="xl-row"><div class="xl-column-main"><div class="description"><h4>{{ \'terminology.welcomeApplicationMainTitle\' | i18n }}</h4><p>{{ \'terminology.welcomeApplicationMainDescription\' | i18n }}</p></div><div class="description"><h4>{{ \'terminology.createPackage\' | i18n }}</h4><p>{{ \'terminology.createPackageDescription\' | i18n }}</p><div class="question"><div class="xl-button xl-secondary button-welcome svg-icon icon_add_application" ng-click="vm.newDeploymentPackage()">{{ \'terminology.createPackage\' | i18n }}</div></div></div><div class="description"><h4>{{ \'terminology.importPackage\' | i18n }}</h4><p>{{ \'terminology.importPackageDescription\' | i18n }}</p><div class="question"><div id="import-version" class="xl-button xl-secondary button-welcome svg-icon icon_import" ng-click="vm.importCIs()">{{ \'terminology.importPackage\' | i18n }}</div></div></div></div><!--\n\n---><div class="xl-column-aside" xl-sticky-parent><div class="xl-help-block" xl-sticky><h4>Help</h4><p>A deployment package represents a version of an application. It contains:</p><ul><li>Deployables, which are the physical files (artifacts) that make up a specific version of the application</li><li>Middleware resource specifications that are required for the application</li></ul><p>For example, a deployable could be an application binary, a configuration file, web content, a datasource, a queue specification, or a timer configuration.</p><p>The deployment package should contain everything that your application needs to run and that should be removed if your application is undeployed (that is, resources that are not shared among multiple applications).</p><p>Here, you can choose whether to:</p><ul><li>Create a deployment package by providing files and configuring middleware resource specifications</li><li>Import a premade deployment package (DAR file) from external storage, your computer, or the XL Deploy server</li></ul></div></div></div></div>');

  $templateCache.put('application/tabs/deployment-package/deployable-modal/deployable-modal.html', '<h4 ng-if="isSourceArtifact  && displayMode === \'creation\'">{{ \'terminology.addFileTitle\' | i18n }}</h4><h4 ng-if="isSourceArtifact  && displayMode !== \'creation\'">{{ \'terminology.updateFileTitle\' | i18n }}</h4><h4 ng-if="!isSourceArtifact && displayMode === \'creation\'">{{ \'terminology.addResourceTitle\' | i18n }}</h4><h4 ng-if="!isSourceArtifact && displayMode !== \'creation\'">{{ \'terminology.updateResourceTitle\' | i18n }}</h4><div class="scrollable"><div class="form-wrapper"><div id="xlArtifactCi" xl-dip-deployable-ci ng-model="deployableCiModel" form-model="formDeployableCiModel.form" types="typesDeployableCi" handlers="dipHandlers.formHandlers" is-source-artifact="isSourceArtifact" display-mode="displayMode"></div><div class="xl-button-container"><button ng-click="cancel()" class="xl-button xl-cancel">{{ \'terminology.cancelButton\' | i18n }}</button> <button ng-click="create()" class="save xl-button xl-primary" ng-disabled="isDisabledSaveButton()" ng-if="displayMode === \'creation\'">{{ \'terminology.createButton\' | i18n }}</button> <button ng-click="create()" class="save xl-button xl-primary" ng-disabled="isDisabledSaveButton()" ng-if="displayMode !== \'creation\'">{{ \'terminology.updateButton\' | i18n }}</button></div></div></div>');

}]);

})();