from xld.openshift.deploymentconfig.deployment_config_helper import DeploymentConfigHelper
from xld.kubernetes.service.exposedservices.service_steps_helper import ExposedServiceStepsHelper

DeploymentConfigHelper.enrich_app_selectors(deployed)
previous_deployment_config_name = previousDeployed.deploymentConfigName if previousDeployed.deploymentConfigName else previousDeployed.name
deployment_config_name = deployed.deploymentConfigName if deployed.deploymentConfigName else deployed.name

if deployment_config_name != previous_deployment_config_name:
    raise RuntimeError("DeploymentConfig name can't be modified.")

if len(deployed.template) > 1:
    raise RuntimeError("DeploymentConfig can't be created, attribute template cannot have more than one template")

if len(deployed.template) == 0:
    raise RuntimeError("DeploymentConfig can't be created, attribute template is mandatory")

if len(deployed.strategy) > 1:
    raise RuntimeError("DeploymentConfig can't be created, attribute strategy cannot have more than 1 item")

context.addStepWithCheckpoint(steps.jython(
    description="Modify DeploymentConfig {0}".format(DeploymentConfigHelper.get_deployment_config_name(deployed)),
    script="xld/openshift/deploymentconfig/modify.py",
    order=deployed.modifyOrder
), delta)

context.addStep(steps.jython(
    description="Wait for DeploymentConfig {0} to be modified".format(DeploymentConfigHelper.get_deployment_config_name(deployed)),
    script="xld/openshift/deploymentconfig/create_update_wait.py",
    order=deployed.modifyOrder + 1
))

for pod_template in previousDeployed.template:
    old_services = ExposedServiceStepsHelper.get_exposed_services(pod_template.containers,pod_template.labels,
                                                                  DeploymentConfigHelper.get_deployment_config_name(previousDeployed))
for pod_template in deployed.template:
    new_services = ExposedServiceStepsHelper.get_exposed_services(pod_template.containers,pod_template.labels,
                                                                  DeploymentConfigHelper.get_deployment_config_name(deployed))
ExposedServiceStepsHelper(context, steps).add_modify_steps(deployed, previousDeployed, old_services, new_services, delta)