from kubernetes.client.rest import ApiException
from xld.openshift.resource_provider import ImageStreamResourceProvider
from xld.openshift.imagestream.image_stream_helper import ImageStreamHelper

result = "SUCCESS"
image_stream_dict = ImageStreamHelper.read_image_stream(previousDeployed)
with ImageStreamResourceProvider(previousDeployed.container) as image_stream_resource_provider:
    try:
        image_streams = image_stream_resource_provider.filter_resources_by_definition(namespace=previousDeployed.container.projectName,
                                                                                      resource_definition=image_stream_dict)

        if 'items' in dir(image_streams) and image_streams.items is not None and len(image_streams.items) > 0:
            print "Waiting for Image Stream to be destroyed..."
            result = "RETRY"

    except ApiException as e:
        print("API error while waiting for image stream: {0}".format(e))
        raise RuntimeError("Image Stream wait failed.")
