from xld.openshift.connector import OpenShiftConnector
from kubernetes.client.rest import ApiException
from xld.openshift.route.route_helper import RouteHelper
from xld.openshift.resource_provider import RouteResourceProvider

result = "SUCCESS"
connector = OpenShiftConnector(previousDeployed.container.container, previousDeployed.container.token)
route_dict = RouteHelper.read_route(previousDeployed)

try:
    with RouteResourceProvider(previousDeployed.container) as route_resource_provider:
        routes = route_resource_provider.filter_resources_by_definition(namespace=previousDeployed.container.projectName,
                                                                        resource_definition=route_dict)
    if routes.items:
        print("Waiting for Route to be deleted ...")
        result = "RETRY"

except ApiException as e:
    print("API error while waiting for route: {0}".format(e))
    raise RuntimeError("Route wait failed.")
