import json

import yaml
from kubernetes.client.apis import core_v1_api
from openshift import client
from resource_provider import get_resource
from xld.openshift.factories.client_factory import OpenShiftClientFactory


class OpenShiftConnector(object):
    def __init__(self, server):
        self.apiclient = OpenShiftClientFactory(server).create()
        self.oapi = client.OapiApi(self.apiclient)
        self.k8sapi = core_v1_api.CoreV1Api(self.apiclient)

    def client(self):
        return self.apiclient

    def oapi_client(self):
        return self.oapi

    def create_resource_from_object(self, namespace, resource_object):
        provider = get_resource(resource_object["kind"], self)
        k8sapi_result = provider.create(namespace=namespace, resource_definition=resource_object)
        print("Deployment created. status='%s'" % str(k8sapi_result.status))
        return k8sapi_result

    def modify_resource_from_object(self, namespace, resource_object):
        provider = get_resource(resource_object["kind"], self)
        k8sapi_result = provider.modify(namespace=namespace, resource_definition=resource_object)
        print("Deployment modified. status='%s'" % str(k8sapi_result.status))
        return k8sapi_result

    def delete_resource_from_object(self, namespace, resource_object):
        provider = get_resource(resource_object["kind"], self)
        k8sapi_result = provider.delete(namespace=namespace, resource_definition=resource_object)
        return k8sapi_result

    def filter_resources_by_object(self, namespace, resource_object):
        provider = get_resource(resource_object["kind"], self)
        k8sapi_result = provider.filter_resources_by_definition(
            namespace=namespace,
            resource_definition=resource_object
        )
        return k8sapi_result

    def parse_resource_definition(self, definition_string):
        try:
            return json.loads(definition_string)
        except:
            try:
                return yaml.safe_load(definition_string)
            except:
                raise