from kubernetes.client.rest import ApiException
from xld.openshift.resource_provider import ImageStreamResourceProvider
from xld.openshift.imagestream.image_stream_helper import ImageStreamHelper

image_stream_dict = ImageStreamHelper.read_image_stream(deployed)
image_stream_resource_provider = ImageStreamResourceProvider(deployed.container)

try:
    print("Updating Image Stream {0}".format(image_stream_dict["metadata"]["name"]))
    image_stream_resource_provider.modify(namespace=deployed.container.projectName, resource_definition=image_stream_dict)

except ApiException as e:
    print("API error while updating Image Stream: {0}".format(e))
    raise RuntimeError("Image Stream modification failed.")
