class RouteHelper(object):

    @staticmethod
    def read_route(deployed_route):
        route_dict = {"kind": "Route"}
        route_dict["metadata"] = {"name": RouteHelper.get_route_name(deployed_route)}
        spec = {
            "to": {
                "kind": "Service",
                "name": deployed_route.serviceName,
                "weight": deployed_route.serviceWeight
            },
            "host": deployed_route.hostName,
            "path": deployed_route.path,
            "wildcardPolicy": deployed_route.wildcardPolicy
        }

        if deployed_route.alternateServices:
            spec["alternateBackends"] = RouteHelper.__read_alternate_services(deployed_route)

        if deployed_route.targetPort:
            spec["port"] = {"targetPort": deployed_route.targetPort}

        if deployed_route.terminationType != 'None':
            spec["tls"] = RouteHelper.__read_tls(deployed_route)

        route_dict["spec"] = spec

        return route_dict

    @staticmethod
    def __read_tls(deployed_route):
        return {
            "termination": deployed_route.terminationType.lower(),
            "certificate": deployed_route.certificate,
            "key": deployed_route.key,
            "caCertificate": deployed_route.caCertificate,
            "destinationCACertificate": deployed_route.destinationCACertificate,
            "insecureEdgeTerminationPolicy": deployed_route.insecureEdgeTerminationPolicy
        }

    @staticmethod
    def __read_alternate_services(deployed_route):
        alternate_services = []
        for service_name, service_weight in deployed_route.alternateServices.items():
            alternate_service = {
                "kind": "Service",
                "name": service_name
            }
            if service_weight and not (service_weight == 'null' or service_weight.strip() == ''):
                alternate_service["weight"] = int(service_weight.strip())

            alternate_services.append(alternate_service)

        return alternate_services

    @staticmethod
    def get_route_name(deployed):
        return deployed.routeName if deployed.routeName else deployed.name
