# coding: utf-8

"""
    OpenShift API (with Kubernetes)

    OpenShift provides builds, application lifecycle, image content management, and administrative policy on top of Kubernetes. The API allows consistent management of those objects.  All API operations are authenticated via an Authorization bearer token that is provided for service accounts as a generated secret (in JWT form) or via the native OAuth endpoint located at /oauth/authorize. Core infrastructure components may use client certificates that require no authentication.  All API operations return a 'resourceVersion' string that represents the version of the object in the underlying storage. The standard LIST operation performs a snapshot read of the underlying objects, returning a resourceVersion representing a consistent version of the listed objects. The WATCH operation allows all updates to a set of objects after the provided resourceVersion to be observed by a client. By listing and beginning a watch from the returned resourceVersion, clients may observe a consistent view of the state of one or more objects. Note that WATCH always returns the update after the provided resourceVersion. Watch may be extended a limited time in the past - using etcd 2 the watch window is 1000 events (which on a large cluster may only be a few tens of seconds) so clients must explicitly handle the \"watch to old error\" by re-listing.  Objects are divided into two rough categories - those that have a lifecycle and must reflect the state of the cluster, and those that have no state. Objects with lifecycle typically have three main sections:  * 'metadata' common to all objects * a 'spec' that represents the desired state * a 'status' that represents how much of the desired state is reflected on   the cluster at the current time  Objects that have no state have 'metadata' but may lack a 'spec' or 'status' section.  Objects are divided into those that are namespace scoped (only exist inside of a namespace) and those that are cluster scoped (exist outside of a namespace). A namespace scoped resource will be deleted when the namespace is deleted and cannot be created if the namespace has not yet been created or is in the process of deletion. Cluster scoped resources are typically only accessible to admins - resources like nodes, persistent volumes, and cluster policy.  All objects have a schema that is a combination of the 'kind' and 'apiVersion' fields. This schema is additive only for any given version - no backwards incompatible changes are allowed without incrementing the apiVersion. The server will return and accept a number of standard responses that share a common schema - for instance, the common error type is 'metav1.Status' (described below) and will be returned on any error from the API server.  The API is available in multiple serialization formats - the default is JSON (Accept: application/json and Content-Type: application/json) but clients may also use YAML (application/yaml) or the native Protobuf schema (application/vnd.kubernetes.protobuf). Note that the format of the WATCH API call is slightly different - for JSON it returns newline delimited objects while for Protobuf it returns length-delimited frames (4 bytes in network-order) that contain a 'versioned.Watch' Protobuf object.  See the OpenShift documentation at https://docs.openshift.org for more information. 

    OpenAPI spec version: latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class V1CSIPersistentVolumeSource(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'driver': 'str',
        'read_only': 'bool',
        'volume_handle': 'str'
    }

    attribute_map = {
        'driver': 'driver',
        'read_only': 'readOnly',
        'volume_handle': 'volumeHandle'
    }

    def __init__(self, driver=None, read_only=None, volume_handle=None):
        """
        V1CSIPersistentVolumeSource - a model defined in Swagger
        """

        self._driver = None
        self._read_only = None
        self._volume_handle = None
        self.discriminator = None

        self.driver = driver
        if read_only is not None:
          self.read_only = read_only
        self.volume_handle = volume_handle

    @property
    def driver(self):
        """
        Gets the driver of this V1CSIPersistentVolumeSource.
        Driver is the name of the driver to use for this volume. Required.

        :return: The driver of this V1CSIPersistentVolumeSource.
        :rtype: str
        """
        return self._driver

    @driver.setter
    def driver(self, driver):
        """
        Sets the driver of this V1CSIPersistentVolumeSource.
        Driver is the name of the driver to use for this volume. Required.

        :param driver: The driver of this V1CSIPersistentVolumeSource.
        :type: str
        """
        if driver is None:
            raise ValueError("Invalid value for `driver`, must not be `None`")

        self._driver = driver

    @property
    def read_only(self):
        """
        Gets the read_only of this V1CSIPersistentVolumeSource.
        Optional: The value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write).

        :return: The read_only of this V1CSIPersistentVolumeSource.
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """
        Sets the read_only of this V1CSIPersistentVolumeSource.
        Optional: The value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write).

        :param read_only: The read_only of this V1CSIPersistentVolumeSource.
        :type: bool
        """

        self._read_only = read_only

    @property
    def volume_handle(self):
        """
        Gets the volume_handle of this V1CSIPersistentVolumeSource.
        VolumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls. Required.

        :return: The volume_handle of this V1CSIPersistentVolumeSource.
        :rtype: str
        """
        return self._volume_handle

    @volume_handle.setter
    def volume_handle(self, volume_handle):
        """
        Sets the volume_handle of this V1CSIPersistentVolumeSource.
        VolumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls. Required.

        :param volume_handle: The volume_handle of this V1CSIPersistentVolumeSource.
        :type: str
        """
        if volume_handle is None:
            raise ValueError("Invalid value for `volume_handle`, must not be `None`")

        self._volume_handle = volume_handle

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, V1CSIPersistentVolumeSource):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
