import os
import tempfile
from com.xebialabs.deployit.plugin.openshift import LoaderUtil
from java.nio.file import Files, Paths, StandardCopyOption

from xld.openshift.client.configuration import OpenShiftConfigurationObject
from openshift.client import ApiClient
from xld.kubernetes.factories.client_factory import KubernetesClientFactory
from kubernetes.config.kube_config import KubeConfigLoader


class OpenShiftClientFactory(KubernetesClientFactory):
    def __init__(self, container):
        super(OpenShiftClientFactory, self).__init__(container)
        self.__server = container

    def create(self):
        if not self.__server.verifyCertificates:
            self._disable_https_warnings()
        cluster = self._create_cluster(server_url=self.__server.serverUrl,
                                       skip_tls=not self.__server.verifyCertificates)
        user = self._create_user(token=self.__server.openshiftToken)
        context = self._create_context()
        config_params = self._get_config_params(cluster=cluster, context=context, user=user)
        return ApiClient(configuration=self.__get_config(config_params, self.__server.serverUrl))

    def __get_config(self, config_params, server_url):
        config = OpenShiftConfigurationObject()
        config.verify_ssl = self.__server.verifyCertificates
        config_loader = KubeConfigLoader(config_dict=config_params)
        config_loader.host = server_url
        config_loader.load_and_set(client_configuration=config)
        if not config.ssl_ca_cert:
            config.ssl_ca_cert = self._set_ca_bundle_path(path="certifi/cacert.pem")
        return config
