from kubernetes.client.rest import ApiException
from xld.openshift.connector import OpenShiftConnector
from xld.openshift.resource_provider import RouteResourceProvider
from xld.openshift.route.route_helper import RouteHelper
from xld.kubernetes.commons.common_utils import CommonUtils

connector = OpenShiftConnector(deployed.container.container)
route_dict = RouteHelper.read_route(deployed)

try:
    route_resource_provider = RouteResourceProvider(deployed.container)
    print("Creating route {0}".format(route_dict["metadata"]["name"]))
    CommonUtils.print_request_dump(deployed.container.container, route_dict, route_dict["kind"],
                                   route_dict["apiVersion"])
    route_response = route_resource_provider.create(namespace=deployed.container.projectName, resource_definition=route_dict)
    CommonUtils.print_response_dump(deployed.container.container, route_response)

except ApiException as e:
    print("API error while creating route: {0}".format(e))
    raise RuntimeError("Route creation failed.")
