from xld.openshift.deploymentconfig.deployment_config_helper import DeploymentConfigHelper
from xld.openshift.resource_provider import DeploymentConfigResourceProvider
from xld.kubernetes.commons.common_utils import CommonUtils

deployment_config_dict = DeploymentConfigHelper.read_deployment_config(deployed)
deploymentconfig_resource_provider = DeploymentConfigResourceProvider(deployed.container)


print("Updating Pods using DeploymentConfig {0}".format(deployment_config_dict["metadata"]["name"]))
CommonUtils.print_request_dump(deployed.container.container, deployment_config_dict, deployment_config_dict["kind"],
                               deployment_config_dict["apiVersion"])
deployments = deploymentconfig_resource_provider.modify(namespace=deployed.container.projectName,
                                                        resource_definition=deployment_config_dict)
CommonUtils.print_response_dump(deployed.container.container, deployments)