from xld.kubernetes.resource.factory import K8SResourceFactory

from xld.openshift.resource_provider import OpenshiftResourceProvider


class OpenShiftResourceFactory(K8SResourceFactory):
    def __init__(self, deployed):
        super(OpenShiftResourceFactory, self).__init__(deployed)
        self.__deployed = deployed

    def get(self, data):
        return self._resolve(data)

    @staticmethod
    def get_resource_order():
        return K8SResourceFactory.get_resource_order()

    @staticmethod
    def get_resource_wait_details():
        return {
            "Create": {
                "Default": {'script': 'create_update_wait', 'action': "created"},
                "Pod": {'script': 'create_update_wait', 'action': "in running state"},
                "Deployment": {'script': 'deployment/create_update_wait', 'action': "in running state"},
                "StatefulSet": {'script': 'deployment/create_update_wait', 'action': "in running state"},
                "PersistentVolumeClaim": {'script': 'create_update_wait', 'action': "in Bound phase"}
            },
            "Destroy": {
                "Default": {'script': 'delete_wait', 'action': "destroyed completely"}
            },
            "Modify": {
                "Default": {'script': 'create_update_wait', 'action': "modified"},
                "Pod": {'script': 'create_update_wait', 'action': "in running state"},
                "Deployment": {'script': 'deployment/create_update_wait', 'action': "in running state"},
                "StatefulSet": {'script': 'deployment/create_update_wait', 'action': "in running state"}
            }
        }

    def _resolve(self, data):
        return OpenshiftResourceProvider(self.__deployed.container, data["kind"],
                                         data["apiVersion"] if 'apiVersion' in data else 'v1')
