class ImageStreamHelper(object):
    @staticmethod
    def read_image_stream(deployed):
        image_stream_dict = {"kind": "ImageStream", "apiVersion": "v1"}
        image_stream_dict["metadata"] = {"name": ImageStreamHelper.get_image_stream_name(deployed)}
        tag = {
            "importPolicy": {
                "insecure": not deployed.verifyCertificates
            },
            "from": {
                "kind": "DockerImage",
                "name": ImageStreamHelper.__get_url_with_image_name(deployed.imageSourceUrl,
                                                                    ImageStreamHelper.__get_image_name(
                                                                        deployed.imageNameAndTag))
            },
            "name": ImageStreamHelper.__get_image_tag(deployed.imageNameAndTag)
        }
        image_stream_dict["spec"] = {"tags": [tag]}
        return image_stream_dict

    @staticmethod
    def __get_url_with_image_name(url, image_name):
        return "{0}{1}{2}".format(ImageStreamHelper.__get_http_stripped_url(url), '/' if not url.endswith("/") else '',
                                  image_name)

    @staticmethod
    def __get_http_stripped_url(url):
        if url.startswith("http://"):
            return url[7:]
        elif url.startswith("https://"):
            return url[8:]
        else:
            return url

    @staticmethod
    def __get_image_name(image_name_and_tag):
        splits = image_name_and_tag.split(":") if image_name_and_tag else []
        return splits[0].strip()

    @staticmethod
    def __get_image_tag(image_name_and_tag):
        splits = image_name_and_tag.split(":") if image_name_and_tag else []
        return splits[1].strip() if bool(len(splits) > 1 and splits[1].strip()) else "latest"

    @staticmethod
    def get_image_stream_name(deployed):
        return deployed.imageStreamName if deployed.imageStreamName else deployed.name
