import urllib3

from xld.openshift.client.configuration import OpenShiftConfigurationObject
from openshift.dynamic.client import DynamicClient
from kubernetes.client.api_client import ApiClient
from xld.kubernetes.factories.client_factory import KubernetesClientFactory
from kubernetes.config.kube_config import KubeConfigLoader
from multiprocessing.pool import ThreadPool
from xld.kubernetes.factories.client_factory import KubernetesRESTClientObject
from com.xebialabs.deployit.plugin.openshift.helper import ClientFactory, ProxyConfig



class OpenShiftClientFactory(KubernetesClientFactory):
    def __init__(self, container):
        super(OpenShiftClientFactory, self).__init__(container)
        self.__server = container

    def create(self):
        if not self.__server.verifyCertificates:
            self._disable_https_warnings()
        cluster = self._create_cluster(server_url=self.__server.serverUrl,
                                       skip_tls=not self.__server.verifyCertificates)
        user = self._create_user(token=self.__server.openshiftToken)
        context = self._create_context()
        config_params = self._get_config_params(cluster=cluster, context=context, user=user)

        proxy_url=None
        proxies=None
        if self.__server.proxyServer:
            proxy_url = "{}://{}:{}".format(str(self.__server.proxyServer.protocol).lower(), self.__server.proxyServer.hostname, self.__server.proxyServer.port)
            proxies = urllib3.make_headers(proxy_basic_auth="{}:{}".format(self.__server.proxyServer.username, self.__server.proxyServer.password))

        return OpenshiftApiClient(configuration=self.__get_config(config_params, self.__server.serverUrl, proxy_url), proxy_headers=proxies)

    def create_dynamic_client(self):
        if not self.__server.verifyCertificates:
            self._disable_https_warnings()
        cluster = self._create_cluster(server_url=self.__server.serverUrl,
                                       skip_tls=not self.__server.verifyCertificates)
        user = self._create_user(token=self.__server.openshiftToken)
        context = self._create_context()
        config_params = self._get_config_params(cluster=cluster, context=context, user=user)

        proxy_url=None
        proxies=None
        if self.__server.proxyServer:
            proxy_url = "{}://{}:{}".format(str(self.__server.proxyServer.protocol).lower(), self.__server.proxyServer.hostname, self.__server.proxyServer.port)
            proxies = urllib3.make_headers(proxy_basic_auth="{}:{}".format(self.__server.proxyServer.username, self.__server.proxyServer.password))
        k8s_client = OpenshiftApiClient(configuration=self.__get_config(config_params, self.__server.serverUrl, proxy_url), proxy_headers=proxies)
        dyn_client = DynamicClient(k8s_client)

        return dyn_client

    def create_java_client(self):
        print("Initializing java client")
        proxy_config = None

        if self.__server.proxyServer:
            print("Configuring java proxy")
            proxy_config = ProxyConfig(
                self.__server.proxyServer.username, self.__server.proxyServer.password, str(self.__server.proxyServer.protocol), self.__server.proxyServer.hostname,
                self.__server.proxyServer.port)

        return ClientFactory().instanceClient(self.__server.serverUrl, self.__server.openshiftToken, self.__server.verifyCertificates, proxy_config)

    def __get_config(self, config_params, server_url, proxy_url):
        config = type.__call__(OpenShiftConfigurationObject)
        config.verify_ssl = self.__server.verifyCertificates
        config_loader = KubeConfigLoader(config_dict=config_params)
        config_loader.host = server_url
        config_loader.load_and_set(client_configuration=config)
        if not config.ssl_ca_cert:
            config.ssl_ca_cert = self._set_ca_bundle_path(path="certifi/cacert.pem")
        config.proxy = proxy_url
        return config


class OpenshiftApiClient(ApiClient):
    def __init__(self, configuration=None, header_name=None, header_value=None, cookie=None, proxy_headers=None):
        if configuration is None:
            configuration = OpenShiftConfigurationObject()
        self.configuration = configuration
        self.proxy_headers = proxy_headers
        self.pool_threads = ThreadPool()
        self.rest_client = KubernetesRESTClientObject(configuration, proxy_headers=proxy_headers)
        self.default_headers = {}
        if header_name is not None:
            self.default_headers[header_name] = header_value
        self.cookie = cookie
        # Set default User-Agent.
        self.user_agent = 'Swagger-Codegen/10.0.1/python'