from kubernetes.client.apis import core_v1_api
from xld.openshift.factories.client_factory import OpenShiftClientFactory


class OpenShiftConnector(object):
    def __init__(self, server):
        self.oapi = OpenShiftClientFactory(server).create_dynamic_client()
        self.apiclient = OpenShiftClientFactory(server).create()
        self.k8sapi = core_v1_api.CoreV1Api(self.apiclient)
        self.oapijava = OpenShiftClientFactory(server).create_java_client()

    def client(self):
        return self.apiclient

    def oapi_client(self):
        return self.oapi

    def oapi_java(self):
        return self.oapijava

    def __enter__(self):
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        if self.apiclient:
            self.apiclient.rest_client.pool_manager.__exit__(exc_type, exc_val, exc_tb)
            self.oapi.client.__del__()