import requests
from xldpodman import getBaseURL
import json

# "portmappings": [
#     {
#         "container_port": 0,
#         "host_ip": "string",
#         "host_port": 0,
#         "protocol": "string",
#         "range": 0
#     }
# ]

pod_name = deployed.PodName or deployed.name
podDict={'cgroup_parent': deployed.cgroupParent,
         'name': pod_name,
         'infra_image': deployed.infra_image,
         'labels': deployed.labels,
         'hostname': deployed.hostname,
         'cpu_period': deployed.cpu_period,
         'cpu_quota': deployed.cpu_quota,
         'infra_command': deployed.infra_command,
         'no_infra': deployed.no_infra,
         'no_manage_hosts': deployed.no_manage_hosts,
         'pod_create_command': deployed.pod_create_command,
         'pod_devices': deployed.pod_devices
         #'portmappings': deployed.portmappings
         }

print "Creating Pod", pod_name
url = getBaseURL(deployed.container)
url = url + "/libpod/pods/create"
app_json = json.dumps(podDict)
response = requests.post(url = url, data = app_json)
response.raise_for_status()  # raises exception when not a 2xx response
reponseLoad = response.json()
deployed.PodId = reponseLoad['Id']
print "Pod has been created with ID", deployed.PodId
if(deployed.start_pod):
    newurl = getBaseURL(deployed.container)
    newurl = newurl + "/libpod/pods/"+deployed.PodId+"/start"
    responseres = requests.post(url = newurl)
    responseres.raise_for_status()
    print "Pod has been Started with ID", deployed.PodId

