#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xldpodman import getBaseURL
import requests

registries = deployed.container.registries
registry = None
authConf = None
credentials = None
# Split image name into repository and tag
last_colon = deployed.image.rfind(':')
last_slash = deployed.image.rfind('/')
has_tag = last_colon != -1 and (last_slash == -1 or last_slash < last_colon)
if has_tag:
    image_repository = deployed.image[:last_colon]
    image_tag = deployed.image[last_colon+1:]
else:
    image_repository = deployed.image
    image_tag = 'latest'

for r in registries:
    if r.url in image_repository:
        registry = r
        break

if registry:
    authConf = registry.username+':'+registry.password
else:
    if len(registries)>0:
        print ('fallback: Using the first registry for auth username and pwd !')
        iterator = iter(registries)
        firstRegistry = next(iterator, None)
        authConf = firstRegistry.username+':'+firstRegistry.password
    else:
        print('no auth can be used as no registry provided, check settings !!')

print "Pulling", image_repository, "image with tag", image_tag

url = getBaseURL(deployed.container)
url = url +"/libpod/images/pull"

if authConf is not None:
    params={'reference': deployed.image , 'credentials': authConf}
else:
    params={'reference': deployed.image}
response = requests.post(url = url, params=params)
response.raise_for_status()  # raises exception when not a 2xx response
#------------------------------------
