<#assign containerName = deployed.containerName?default(deployed.name)>
<#assign image = deployed.image>
<#assign command = deployed.command?if_exists>
<#assign entrypoint = deployed.entrypoint?if_exists>
<#assign environment = deployed.environment?if_exists>
<#assign networkMode = deployed.networks?if_exists>
<#assign hostname = deployed.hostname?if_exists>
<#assign ipaddress = deployed.ipaddress?if_exists>
<#assign domain = deployed.domainname?if_exists>
<#assign labels = deployed.labels?if_exists>
<#assign tty = deployed.tty?if_exists>
<#assign workDir = deployed.workDir?if_exists>
<#assign timezone = deployed.timeZone?if_exists>
<#assign init = deployed.init?if_exists>
<#assign dnsOptions = deployed.dnsOptions?if_exists>
<#assign restartPolicyName = deployed.restartPolicyName?if_exists>
<#assign pidMode = deployed.pidMode?if_exists>
<#assign memoryLimit = deployed.memoryLimit?if_exists>
<#assign publishAllPorts = deployed.publishAllPorts?if_exists>
<#assign privileged = deployed.privileged?if_exists>
<#assign containerVolumes = deployed.containerVolumes?if_exists>
<#assign containerImageVolume = deployed.containerImageVolume?if_exists>
<#assign portBindings = deployed.portBindings?if_exists>
<#assign additionalFlags = deployed.additionalFlags?if_exists>
<#assign restartPolicyMaximumRetryCount = deployed.restartPolicyMaximumRetryCount?if_exists>
<#assign podmanCommand = "podman create">

<#if restartPolicyName?length gt 0>
  <#assign restartPolicy = " --restart ${restartPolicyName}">
  <#if restartPolicyMaximumRetryCount?is_number && restartPolicyName?has_content && restartPolicyName=="on-failure">
    <#assign restartPolicy = "${restartPolicy}:${restartPolicyMaximumRetryCount}">
  </#if>
</#if>

<#assign volumeMappings = []>
<#if containerVolumes?size gt 0>
  <#list containerVolumes as volume>
    <#assign volumeMapping = "${volume.Dest}:/${volume.Name}">
    <#if volume.Options?size gt 0>
      <#assign volumeMapping = "${volumeMapping}:${volume.Options?join(',')}">
    </#if>
    <#assign volumeMappings += [volumeMapping]>
  </#list>
</#if>

<#assign imageVolumeMappings = []>
<#if containerImageVolume?size gt 0>
  <#list containerImageVolume as imageVolume>
    <#assign imageVolumeMapping = "type=${imageVolume.mountType},source=${imageVolume.Source},target=${imageVolume.Destination}">
    <#if imageVolume.ReadWrite>
      <#assign imageVolumeMapping = imageVolumeMapping + ",rw">
    <#else>
      <#assign imageVolumeMapping = imageVolumeMapping + ",ro">
    </#if>
    <#assign imageVolumeMappings += [imageVolumeMapping]>
  </#list>
</#if>

<#assign portMappings = []>
<#if portBindings?size gt 0>
  <#list portBindings as portBinding>
     <#if portBinding.range?has_content>
       <#assign portMapping = "${portBinding.hostIp}:${portBinding.hostPort}-${portBinding.hostPort + (portBinding.range - 1)}:${portBinding.containerPort}-${portBinding.containerPort + (portBinding.range - 1)}/${portBinding.protocol}">
       <#assign portMappings = portMappings + [portMapping]>
     <#else>
       <#assign portMapping = "${portBinding.hostIp}:${portBinding.hostPort}:${portBinding.containerPort}/${portBinding.protocol}">
       <#assign portMappings = portMappings + [portMapping]>
     </#if>
     <#if portBinding.expose?has_content>
       <#assign expose = portBinding.expose>
       <#assign podmanCommand += " --expose ${expose}">
     </#if>
  </#list>
</#if>

<#if deployed.dnsOptions?size gt 0>
  <#list deployed.dnsOptions as dnsOption>
    <#assign podmanCommand += " --dns-option ${dnsOption}">
  </#list>
</#if>

<#if memoryLimit?? && memoryLimit?length gt 0> <#assign podmanCommand += " --memory ${memoryLimit}"> </#if>
<#if pidMode?length gt 0> <#assign podmanCommand += " --pid ${pidMode}"> </#if>
<#if init> <#assign podmanCommand += " --init"> </#if>
<#if publishAllPorts> <#assign podmanCommand += " --publish-all"> </#if>
<#if restartPolicy?has_content && restartPolicy?length gt 0> <#assign podmanCommand += "${restartPolicy}"> </#if>
<#if privileged> <#assign podmanCommand += " --privileged"> </#if>

<#if networkMode?size gt 0>
  <#list networkMode as network>
    <#assign podmanCommand += " --network ${network}">
  </#list>
</#if>

<#if environment?size gt 0>
  <#list environment?keys as key>
    <#assign value = environment[key]>
    <#assign podmanCommand += " --env ${key}=${value}">
  </#list>
</#if>

<#if labels?size gt 0>
  <#list labels as key, value>
    <#assign podmanCommand += " --label ${key}=${value}">
  </#list>
</#if>

<#if hostname?length gt 0 && ipaddress?length gt 0> <#assign podmanCommand += " --hostname ${hostname}:${ipaddress}">
<#elseif hostname?length gt 0> <#assign podmanCommand += " --hostname ${hostname}">
</#if>
<#if domain?length gt 0> <#assign podmanCommand += " --dns ${domain}"> </#if>
<#if tty> <#assign podmanCommand += " --tty"> </#if>
<#if workDir?length gt 0> <#assign podmanCommand += " --workdir ${workDir}"> </#if>
<#if timezone?length gt 0> <#assign podmanCommand += " --tz ${timezone}"> </#if>
<#if entrypoint?length gt 0> <#assign podmanCommand += " --entrypoint ${entrypoint}"> </#if>

<#if volumeMappings?size gt 0>
  <#list volumeMappings as volumeMapping>
    <#assign podmanCommand += " --volume ${volumeMapping}">
  </#list>
</#if>
<#if imageVolumeMappings?size gt 0>
  <#list imageVolumeMappings as imageVolumeMapping>
    <#assign podmanCommand += " --mount ${imageVolumeMapping}">
  </#list>
</#if>
<#if portMappings?size gt 0>
  <#list portMappings as portMapping>
    <#assign podmanCommand += " --publish ${portMapping}">
  </#list>
</#if>

<#if additionalFlags?length gt 0> <#assign podmanCommand += " ${additionalFlags}"> </#if>
<#if containerName?length gt 0> <#assign podmanCommand += " --name ${containerName}"> </#if>

<#assign podmanCommand += " ${image}">
<#if command?length gt 0> <#assign podmanCommand += " ${command}"> </#if>

echo "Creating container ${containerName} from image ${image}"

${podmanCommand}
