<#assign pod_name = deployed.podName?default(deployed.name)>
<#assign labels = deployed.labels?if_exists>
<#assign pod_devices = deployed.pod_devices?if_exists>
<#assign portmappings = deployed.portmappings?if_exists>
<#assign podnetworks = deployed.podnetworks?if_exists>
<#assign portnetwork = deployed.portnetwork?if_exists>
<#assign volumemappings = deployed.volumemappings?if_exists>
<#assign networkOptions = deployed.networkOptions?if_exists>
<#assign additionalFlags = deployed.additionalFlags?if_exists>
<#assign pod_create_command = deployed.pod_create_command?if_exists>

<#assign infra_command = deployed.infra_command?if_exists>
<#assign infra = deployed.infra?if_exists>
<#assign no_manage_hosts = deployed.no_manage_hosts?if_exists>

<#assign podmanPodCreateCommand = "podman pod create">

<#if deployed.cgroupParent?has_content && deployed.cgroupParent?length gt 0>
  <#assign podmanPodCreateCommand += " --cgroup-parent ${deployed.cgroupParent}">
</#if>

<#if deployed.infra_image?has_content && deployed.infra_image?length gt 0>
  <#assign podmanPodCreateCommand += " --infra-image ${deployed.infra_image}">
</#if>

<#if labels?size gt 0>
  <#list labels as key, value>
    <#assign podmanPodCreateCommand += " --label ${key}=${value}">
  </#list>
</#if>

<#if deployed.hostname?has_content && deployed.hostname?length gt 0>
  <#assign podmanPodCreateCommand += " --hostname ${deployed.hostname}">
</#if>

<#if infra_command?length gt 0>
    <#assign podmanPodCreateCommand += " --infra-command ${infra_command}">
</#if>

<#if infra>
  <#assign podmanPodCreateCommand += " --infra">
</#if>

<#if no_manage_hosts>
  <#assign podmanPodCreateCommand += " --no-hosts">
</#if>

<#if pod_devices?size gt 0>
  <#list pod_devices as device>
    <#assign podmanPodCreateCommand += " --device ${device}">
  </#list>
</#if>

<#if portmappings?size gt 0>
  <#list portmappings as portmapping>
    <#if portmapping.range?has_content>
       <#assign portMapping = "${portmapping.hostIp}:${portmapping.hostPort}-${portmapping.hostPort + (portmapping.range - 1)}:${portmapping.containerPort}-${portmapping.containerPort + (portmapping.range - 1)}/${portmapping.protocol}">
       <#assign podmanPodCreateCommand += " --publish ${portMapping}">
    <#else>
       <#assign portMapping = "${portmapping.hostIp}:${portmapping.hostPort}:${portmapping.containerPort}/${portmapping.protocol}">
       <#assign podmanPodCreateCommand += " --publish ${portMapping}">
    </#if>
  </#list>
</#if>

<#if podnetworks?size gt 0>
  <#list podnetworks as podnetwork>
    <#if podnetwork.propertyName?has_content && networkOptions?size gt 0>
       <#assign networkOption = []>
         <#list networkOptions as key, value>
           <#assign networkOption += [key + "=" + value]>
         </#list>
       <#assign podmanPodCreateCommand += " --network ${podnetwork.propertyName}:${networkOption?join(',')}">
    <#elseif podnetwork.propertyName?has_content>
      <#assign podmanPodCreateCommand += " --network ${podnetwork.propertyName}">
    </#if>

    <#if podnetwork.staticMac?size gt 0>
       <#list podnetwork.staticMac as staticMac>
          <#assign podmanPodCreateCommand += " --mac-address ${staticMac}">
       </#list>
    </#if>

    <#if podnetwork.staticIp6?size gt 0>
      <#list podnetwork.staticIp6 as staticIp6>
        <#assign podmanPodCreateCommand += " --ip6 ${staticIp6}">
      </#list>
    </#if>

    <#if podnetwork.staticIp4?size gt 0>
      <#list podnetwork.staticIp4 as staticIp4>
        <#assign podmanPodCreateCommand += " --ip ${staticIp4}">
      </#list>
    </#if>

    <#if podnetwork.aliases?size gt 0>
      <#list podnetwork.aliases as alias>
        <#assign podmanPodCreateCommand += " --network-alias ${alias}">
      </#list>
    </#if>
  </#list>
</#if>

<#if volumemappings?size gt 0>
  <#list volumemappings as volumeMapping>
    <#if volumeMapping.dest?length gt 0>
      <#assign volumeMappingString = "${volumeMapping.volumename}:${volumeMapping.dest}">
    <#else>
      <#assign volumeMappingString = "${volumeMapping.volumename}">
    </#if>
    <#if volumeMapping.options?size gt 0>
      <#assign volumeMappingString += ":${volumeMapping.options?join(',')}">
    </#if>
    <#assign podmanPodCreateCommand += " --volume ${volumeMappingString}">
  </#list>
</#if>

<#if deployed.usernsValue?has_content && deployed.usernsNsmode?length gt 0  && deployed.usernsValue?is_number>
  <#assign podmanPodCreateCommand += " --userns ${deployed.usernsNsmode}:${deployed.usernsValue}">
</#if>
<#if deployed.netnsValue?has_content && deployed.netnsNsmode?length gt 0 && deployed.netnsValue?is_number>
  <#assign podmanPodCreateCommand += " --netns ${deployed.netnsNsmode}:${deployed.netnsValue}">
</#if>
<#if additionalFlags?length gt 0> <#assign podmanPodCreateCommand += " ${additionalFlags}"> </#if>

<#assign podmanPodCreateCommand += " ${pod_name}">

echo "Creating Pod ${pod_name}"
${podmanPodCreateCommand}
if [ $? -ne 0 ]; then
    exit 1
fi

<#if pod_create_command?size gt 0>
  <#list deployed.pod_create_command as command>
    ${command}
    if [ $? -ne 0 ]; then
        exit 1
    fi
  </#list>
</#if>

<#if deployed.start_pod>
  <#assign podmanPodStartCommand = "podman pod start ${pod_name}">
  echo "Starting Pod ${pod_name}"
  ${podmanPodStartCommand}
  if [ $? -ne 0 ]; then
      exit 1
  fi
</#if>
