<#assign image = deployed.image>
<#assign registries = deployed.container.registries>

<#assign lastColon = image?lastIndexOf(":")>
<#assign lastSlash = image?lastIndexOf("/")>
<#assign hasTag = (lastColon != -1) && (lastSlash == -1 || lastSlash < lastColon)>

<#if hasTag>
    <#assign imageRepository = image?substring(0, lastColon)>
    <#assign imageTag = image?substring(lastColon + 1)>
<#else>
    <#assign imageRepository = image>
    <#assign imageTag = "latest">
</#if>

<#assign XRegistryAuth = []>

<#assign registryFound = false>
<#list registries as registry>
       <#assign registryFound = true>
       <#assign XRegistryAuth += ["username=${registry.username},password=${registry.password},serveraddress=${registry.url}"]>
</#list>

<#if !registryFound && (registries?size == 0)>
    echo "No auth can be used as no registry provided, check settings!!"
    exit 1
</#if>

echo "Pulling ${imageRepository} image with tag ${imageTag}"

<#if XRegistryAuth?size gt 0>
    <#list XRegistryAuth as auth>
        <#assign splitAuth = auth?split(",")>
        <#list splitAuth as authPart>
            <#if authPart?startsWith("serveraddress=")>
                <#assign registryUrl = authPart?substring(14)>
            </#if>

            <#if authPart?startsWith("username=")>
                <#assign registryUsername = authPart?substring(9)>
            </#if>

            <#if authPart?startsWith("password=")>
                <#assign registryPassword = authPart?substring(9)>
            </#if>
        </#list>
        <#if registryUrl?? && registryUsername?? && registryPassword??>
           podman login ${registryUrl} --username ${registryUsername} --password ${registryPassword}
           if [ $? -ne 0 ]; then
               exit 1
           fi
        </#if>
    </#list>
<#else>
    echo "No registry authentication information provided."
</#if>

podman pull ${image}
if [ $? -ne 0 ]; then
    exit 1
fi
