#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

def stop_start_podman_container(deployed):
    if deployed is None:
        return

    context.addStep(steps.jython(
        description="Stop Podman container %s on %s" % (deployed.containerName or deployed.name, deployed.container.name),
        order=20,
        script="xldpodman/stop_container.py",
        jython_context={'previousDeployed': deployed}
    ))

    context.addStep(steps.jython(
        description="Start Podman container %s on %s" % (deployed.containerName or deployed.name, deployed.container.name),
        order=80,
        script="xldpodman/start_container.py",
        jython_context={'deployed': deployed}
    ))


def containers(modify_data_volume, noop_delta_container):
    candidates = []
    for delta_v in modify_data_volume:
        for delta in noop_delta_container:
            container = delta.deployed
            if container.name == delta_v.deployed.targetContainer:
                candidates.append(container)
            if container.name == delta_v.previous.targetContainer:
                candidates.append(container)

    return set(candidates)


modify_data_volume = filter(
    lambda delta: delta.operation == "MODIFY" and (delta.deployedOrPrevious.type == "podman.DeployedFolder" or delta.deployedOrPrevious.type == "podman.DeployedFile"),
    deltas.deltas)

noop_delta_container = filter(
    lambda delta: delta.operation == "NOOP" and delta.deployedOrPrevious.type == "podman.Container",
    deltas.deltas)

candidates = containers(modify_data_volume, noop_delta_container)

map(stop_start_podman_container, candidates)
