package com.xebialabs.xldeploy.provisioner

import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployable
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property, TypeIcon}

@Metadata(virtual = true, description = "Base type for all provisionables.")
@TypeIcon("icons/types/upm.Provisionable.svg")
class Provisionable extends BaseDeployable {

  @Property(required = false, description = "Number of instances to launch.", defaultValue = "1")
  var cardinality: String = null

  @Property(description = "The set of CI templates.", asContainment = false, required = false , candidateValuesFilter = "filterByProvisioningPackage")
  var boundTemplates: JSet[Template] = new JHashSet[Template]

  @Property(description = "A list of provisioners associated with the instance.", required = false, asContainment = true)
  var provisioners: JList[Provisioner] = new JArrayList[Provisioner]
}