package com.xebialabs.xldeploy.provisioner;

import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.ProxiesInstance;

@CliObject(name = "authConfig")
public class AuthConfig extends DocumentedObject {

    private BooterConfig config;

    public AuthConfig(ProxiesInstance proxies) {
        this.config = proxies.getCommunicator().getConfig();
    }

    public String username() {
        return config.getUsername();
    }

    public String password() {
        return config.getPassword();
    }

    public String apiUrl() {
        return config.getExtensionApiUrl();
    }

}
